/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.IntTable;
import org.w3c.dom.events.EventListener;

public class EventListenerList {
    protected int n;
    protected Entry head;
    protected IntTable counts = new IntTable();
    protected Entry[] listeners;
    protected HashTable listenersNS = new HashTable();

    public void addListener(String string2, Object object, EventListener eventListener) {
        Entry entry = this.head;
        while (entry != null) {
            if ((string2 != null && string2.equals(entry.namespaceURI) || string2 == null && entry.namespaceURI == null) && entry.listener == eventListener) {
                return;
            }
            entry = entry.next;
        }
        this.head = new Entry(eventListener, string2, object, this.head);
        this.counts.inc(string2);
        ++this.n;
        this.listeners = null;
        this.listenersNS.remove(string2);
    }

    public void removeListener(String string2, EventListener eventListener) {
        if (this.head == null) {
            return;
        }
        if (this.head != null && (string2 != null && string2.equals(this.head.namespaceURI) || string2 == null && this.head.namespaceURI == null) && eventListener == this.head.listener) {
            this.head = this.head.next;
        } else {
            Entry entry = this.head;
            Entry entry2 = this.head.next;
            while (entry2 != null) {
                if ((string2 != null && string2.equals(entry2.namespaceURI) || string2 == null && entry2.namespaceURI == null) && entry2.listener == eventListener) {
                    entry.next = entry2.next;
                    break;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            if (entry2 == null) {
                return;
            }
        }
        this.counts.dec(string2);
        --this.n;
        this.listeners = null;
        this.listenersNS.remove(string2);
    }

    public Entry[] getEventListeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new Entry[this.n];
        int n2 = 0;
        Entry entry = this.head;
        while (entry != null) {
            this.listeners[n2++] = entry;
            entry = entry.next;
        }
        return this.listeners;
    }

    public Entry[] getEventListeners(String string2) {
        if (string2 == null) {
            return this.getEventListeners();
        }
        Entry[] entryArray = (Entry[])this.listenersNS.get(string2);
        if (entryArray != null) {
            return entryArray;
        }
        int n2 = this.counts.get(string2);
        if (n2 == 0) {
            return null;
        }
        entryArray = new Entry[n2];
        this.listenersNS.put(string2, entryArray);
        int n3 = 0;
        Entry entry = this.head;
        while (n3 < n2) {
            if (string2.equals(entry.namespaceURI)) {
                entryArray[n3++] = entry;
            }
            entry = entry.next;
        }
        return entryArray;
    }

    public boolean hasEventListener(String string2) {
        if (string2 == null) {
            return this.n != 0;
        }
        return this.counts.get(string2) != 0;
    }

    public int size() {
        return this.n;
    }

    public class Entry {
        protected EventListener listener;
        protected String namespaceURI;
        protected Object group;
        protected boolean mark;
        protected Entry next;

        public Entry(EventListener eventListener, String string2, Object object, Entry entry) {
            this.listener = eventListener;
            this.namespaceURI = string2;
            this.group = object;
            this.next = entry;
        }

        public EventListener getListener() {
            return this.listener;
        }

        public Object getGroup() {
            return this.group;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }
    }
}

