/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractProcessingInstruction;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;

public class StyleSheetProcessingInstruction
extends AbstractProcessingInstruction
implements LinkStyle {
    protected boolean readonly;
    protected transient StyleSheet sheet;
    protected StyleSheetFactory factory;
    protected transient HashTable pseudoAttributes;

    protected StyleSheetProcessingInstruction() {
    }

    public StyleSheetProcessingInstruction(String string2, AbstractDocument abstractDocument, StyleSheetFactory styleSheetFactory) {
        this.ownerDocument = abstractDocument;
        this.setData(string2);
        this.factory = styleSheetFactory;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean bl2) {
        this.readonly = bl2;
    }

    @Override
    public void setNodeName(String string2) {
    }

    @Override
    public String getTarget() {
        return "xml-stylesheet";
    }

    @Override
    public StyleSheet getSheet() {
        if (this.sheet == null) {
            this.sheet = this.factory.createStyleSheet(this, this.getPseudoAttributes());
        }
        return this.sheet;
    }

    public HashTable getPseudoAttributes() {
        if (this.pseudoAttributes == null) {
            this.pseudoAttributes = new HashTable();
            this.pseudoAttributes.put("alternate", "no");
            this.pseudoAttributes.put("media", "all");
            DOMUtilities.parseStyleSheetPIData(this.data, this.pseudoAttributes);
        }
        return this.pseudoAttributes;
    }

    @Override
    public void setData(String string2) throws DOMException {
        super.setData(string2);
        this.sheet = null;
        this.pseudoAttributes = null;
    }

    @Override
    protected Node newNode() {
        return new StyleSheetProcessingInstruction();
    }
}

