/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class GenericDocument
extends AbstractDocument {
    protected static final String ATTR_ID = "id";
    protected boolean readonly;

    protected GenericDocument() {
    }

    public GenericDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(documentType, dOMImplementation);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean bl2) {
        this.readonly = bl2;
    }

    @Override
    public boolean isId(Attr attr) {
        if (attr.getNamespaceURI() != null) {
            return false;
        }
        return ATTR_ID.equals(attr.getNodeName());
    }

    @Override
    public Element createElement(String string2) throws DOMException {
        return new GenericElement(string2.intern(), this);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    @Override
    public Text createTextNode(String string2) {
        return new GenericText(string2, this);
    }

    @Override
    public Comment createComment(String string2) {
        return new GenericComment(string2, this);
    }

    @Override
    public CDATASection createCDATASection(String string2) throws DOMException {
        return new GenericCDATASection(string2, this);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string2, String string3) throws DOMException {
        return new GenericProcessingInstruction(string2, string3, this);
    }

    @Override
    public Attr createAttribute(String string2) throws DOMException {
        return new GenericAttr(string2.intern(), this);
    }

    @Override
    public EntityReference createEntityReference(String string2) throws DOMException {
        return new GenericEntityReference(string2, this);
    }

    @Override
    public Element createElementNS(String string2, String string3) throws DOMException {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            return new GenericElement(string3.intern(), this);
        }
        return new GenericElementNS(string2.intern(), string3.intern(), this);
    }

    @Override
    public Attr createAttributeNS(String string2, String string3) throws DOMException {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            return new GenericAttr(string3.intern(), this);
        }
        return new GenericAttrNS(string2.intern(), string3.intern(), this);
    }

    @Override
    protected Node newNode() {
        return new GenericDocument();
    }
}

