/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.ElementTraversal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class AbstractElement
extends AbstractParentChildNode
implements Element,
ElementTraversal {
    protected NamedNodeMap attributes;
    protected TypeInfo typeInfo;

    protected AbstractElement() {
    }

    protected AbstractElement(String string2, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        if (abstractDocument.getStrictErrorChecking() && !DOMUtilities.isValidName(string2)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{string2});
        }
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes == null ? (this.attributes = this.createAttributes()) : this.attributes;
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasAttribute(String string2) {
        return this.attributes != null && this.attributes.getNamedItem(string2) != null;
    }

    @Override
    public String getAttribute(String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string2);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public void setAttribute(String string2, String string3) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if ((attr = this.getAttributeNode(string2)) == null) {
            attr = this.getOwnerDocument().createAttribute(string2);
            attr.setValue(string3);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setValue(string3);
        }
    }

    @Override
    public void removeAttribute(String string2) throws DOMException {
        if (!this.hasAttribute(string2)) {
            return;
        }
        this.attributes.removeNamedItem(string2);
    }

    @Override
    public Attr getAttributeNode(String string2) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string2);
    }

    @Override
    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    @Override
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        String string2;
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{attr.getName()});
        }
        return (Attr)this.attributes.removeNamedItemNS(string2, (string2 = attr.getNamespaceURI()) == null ? attr.getNodeName() : attr.getLocalName());
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                namedNodeMap.item(i2).normalize();
            }
        }
    }

    @Override
    public boolean hasAttributeNS(String string2, String string3) {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return this.attributes != null && this.attributes.getNamedItemNS(string2, string3) != null;
    }

    @Override
    public String getAttributeNS(String string2, String string3) {
        Attr attr;
        if (this.attributes == null) {
            return "";
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return (attr = (Attr)this.attributes.getNamedItemNS(string2, string3)) == null ? "" : attr.getValue();
    }

    @Override
    public void setAttributeNS(String string2, String string3, String string4) throws DOMException {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if ((attr = this.getAttributeNodeNS(string2, string3)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(string2, string3);
            attr.setValue(string4);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setValue(string4);
        }
    }

    @Override
    public void removeAttributeNS(String string2, String string3) throws DOMException {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (!this.hasAttributeNS(string2, string3)) {
            return;
        }
        this.attributes.removeNamedItemNS(string2, string3);
    }

    @Override
    public Attr getAttributeNodeNS(String string2, String string3) {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string2, string3);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.typeInfo == null) {
            this.typeInfo = new ElementTypeInfo();
        }
        return this.typeInfo;
    }

    @Override
    public void setIdAttribute(String string2, boolean bl2) throws DOMException {
        AbstractAttr abstractAttr = (AbstractAttr)this.getAttributeNode(string2);
        if (abstractAttr == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
        }
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{string2});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    @Override
    public void setIdAttributeNS(String string2, String string3, boolean bl2) throws DOMException {
        AbstractAttr abstractAttr;
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if ((abstractAttr = (AbstractAttr)this.getAttributeNodeNS(string2, string3)) == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string2, string3});
        }
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{abstractAttr.getNodeName()});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl2) throws DOMException {
        AbstractAttr abstractAttr = (AbstractAttr)attr;
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{abstractAttr.getNodeName()});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    private void updateIdEntry(AbstractAttr abstractAttr, boolean bl2) {
        if (abstractAttr.isIdAttr) {
            if (!bl2) {
                this.ownerDocument.removeIdEntry(this, abstractAttr.getValue());
            }
        } else if (bl2) {
            this.ownerDocument.addIdEntry(this, abstractAttr.getValue());
        }
    }

    protected Attr getIdAttribute() {
        NamedNodeMap namedNodeMap = this.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
            if (!abstractAttr.isId()) continue;
            return abstractAttr;
        }
        return null;
    }

    protected String getId() {
        String string2;
        Attr attr = this.getIdAttribute();
        if (attr != null && (string2 = attr.getNodeValue()).length() > 0) {
            return string2;
        }
        return null;
    }

    @Override
    protected void nodeAdded(Node node) {
        this.invalidateElementsByTagName(node);
    }

    @Override
    protected void nodeToBeRemoved(Node node) {
        this.invalidateElementsByTagName(node);
    }

    private void invalidateElementsByTagName(Node node) {
        Node node2;
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        String string2 = node.getNamespaceURI();
        String string3 = node.getNodeName();
        String string4 = string2 == null ? node.getNodeName() : node.getLocalName();
        block3: for (node2 = this; node2 != null; node2 = node2.getParentNode()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 9: {
                    AbstractParentNode.ElementsByTagNameNS elementsByTagNameNS;
                    AbstractParentNode.ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(node2, string3);
                    if (elementsByTagName != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, "*")) != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string2, string4)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", string4)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string2, "*")) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", "*")) == null) continue block3;
                    elementsByTagNameNS.invalidate();
                }
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.invalidateElementsByTagName(node2);
        }
    }

    protected NamedNodeMap createAttributes() {
        return new NamedNodeHashMap();
    }

    @Override
    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    @Override
    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    @Override
    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    @Override
    protected void checkChildType(Node node, boolean bl2) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(node.getNodeType()), node.getNodeName()});
            }
        }
    }

    public void fireDOMAttrModifiedEvent(String string2, Attr attr, String string3, String string4, short s2) {
        switch (s2) {
            case 2: {
                if (((AbstractAttr)attr).isId()) {
                    this.ownerDocument.addIdEntry(this, string4);
                }
                this.attrAdded(attr, string4);
                break;
            }
            case 1: {
                if (((AbstractAttr)attr).isId()) {
                    this.ownerDocument.updateIdEntry(this, string3, string4);
                }
                this.attrModified(attr, string3, string4);
                break;
            }
            default: {
                if (((AbstractAttr)attr).isId()) {
                    this.ownerDocument.removeIdEntry(this, string3);
                }
                this.attrRemoved(attr, string3);
            }
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled() && !string3.equals(string4)) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", true, false, attr, string3, string4, string2, s2);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    protected void attrAdded(Attr attr, String string2) {
    }

    protected void attrModified(Attr attr, String string2, String string3) {
    }

    protected void attrRemoved(Attr attr, String string2) {
    }

    @Override
    public Element getFirstElementChild() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getLastElementChild() {
        for (Node node = this.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getPreviousElementSibling() {
        Node node;
        for (node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return (Element)node;
    }

    @Override
    public int getChildElementCount() {
        this.getChildNodes();
        return this.childNodes.elementChildren;
    }

    public class ElementTypeInfo
    implements TypeInfo {
        @Override
        public String getTypeNamespace() {
            return null;
        }

        @Override
        public String getTypeName() {
            return null;
        }

        @Override
        public boolean isDerivedFrom(String string2, String string3, int n2) {
            return false;
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public String namespaceURI;
        public String name;
        public Node value;
        public Entry next;

        public Entry(int n2, String string2, String string3, Node node, Entry entry) {
            this.hash = n2;
            this.namespaceURI = string2;
            this.name = string3;
            this.value = node;
            this.next = entry;
        }

        public boolean match(String string2, String string3) {
            if (this.namespaceURI != null ? !this.namespaceURI.equals(string2) : string2 != null) {
                return false;
            }
            return this.name.equals(string3);
        }
    }

    public class NamedNodeHashMap
    implements NamedNodeMap,
    Serializable {
        protected static final int INITIAL_CAPACITY = 3;
        protected Entry[] table = new Entry[3];
        protected int count;

        @Override
        public Node getNamedItem(String string2) {
            if (string2 == null) {
                return null;
            }
            return this.get(null, string2);
        }

        @Override
        public Node setNamedItem(Node node) throws DOMException {
            if (node == null) {
                return null;
            }
            this.checkNode(node);
            return this.setNamedItem(null, node.getNodeName(), node);
        }

        @Override
        public Node removeNamedItem(String string2) throws DOMException {
            return this.removeNamedItemNS(null, string2);
        }

        @Override
        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.count) {
                return null;
            }
            int n3 = 0;
            for (int i2 = 0; i2 < this.table.length; ++i2) {
                Entry entry = this.table[i2];
                if (entry == null) continue;
                do {
                    if (n3++ != n2) continue;
                    return entry.value;
                } while ((entry = entry.next) != null);
            }
            return null;
        }

        @Override
        public int getLength() {
            return this.count;
        }

        @Override
        public Node getNamedItemNS(String string2, String string3) {
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            return this.get(string2, string3);
        }

        @Override
        public Node setNamedItemNS(Node node) throws DOMException {
            String string2;
            if (node == null) {
                return null;
            }
            return this.setNamedItem(string2, (string2 = node.getNamespaceURI()) == null ? node.getNodeName() : node.getLocalName(), node);
        }

        @Override
        public Node removeNamedItemNS(String string2, String string3) throws DOMException {
            AbstractAttr abstractAttr;
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string3 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if ((abstractAttr = (AbstractAttr)this.remove(string2, string3)) == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string3});
            }
            abstractAttr.setOwnerElement(null);
            AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            return abstractAttr;
        }

        public Node setNamedItem(String string2, String string3, Node node) throws DOMException {
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            ((AbstractAttr)node).setOwnerElement(AbstractElement.this);
            AbstractAttr abstractAttr = (AbstractAttr)this.put(string2, string3, node);
            if (abstractAttr != null) {
                abstractAttr.setOwnerElement(null);
                AbstractElement.this.fireDOMAttrModifiedEvent(string3, abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            }
            AbstractElement.this.fireDOMAttrModifiedEvent(string3, (Attr)node, "", node.getNodeValue(), (short)2);
            return abstractAttr;
        }

        protected void checkNode(Node node) {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (AbstractElement.this.getOwnerDocument() != node.getOwnerDocument()) {
                throw AbstractElement.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
            }
            if (node.getNodeType() == 2 && ((Attr)node).getOwnerElement() != null) {
                throw AbstractElement.this.createDOMException((short)4, "inuse.attribute", new Object[]{node.getNodeName()});
            }
        }

        protected Node get(String string2, String string3) {
            int n2 = this.hashCode(string2, string3) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = this.table[n3];
            while (entry != null) {
                if (entry.hash == n2 && entry.match(string2, string3)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }

        protected Node put(String string2, String string3, Node node) {
            Entry entry;
            int n2 = this.hashCode(string2, string3) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry2 = this.table[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.match(string2, string3)) {
                    Node node2 = entry2.value;
                    entry2.value = node;
                    return node2;
                }
                entry2 = entry2.next;
            }
            int n4 = this.table.length;
            if (this.count++ >= n4 - (n4 >> 2)) {
                this.rehash();
                n3 = n2 % this.table.length;
            }
            this.table[n3] = entry = new Entry(n2, string2, string3, node, this.table[n3]);
            return null;
        }

        protected Node remove(String string2, String string3) {
            int n2 = this.hashCode(string2, string3) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = null;
            Entry entry2 = this.table[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.match(string2, string3)) {
                    Node node = entry2.value;
                    if (entry == null) {
                        this.table[n3] = entry2.next;
                    } else {
                        entry.next = entry2.next;
                    }
                    --this.count;
                    return node;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
                Entry entry = entryArray[i2];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n2 = entry2.hash % this.table.length;
                    entry2.next = this.table[n2];
                    this.table[n2] = entry2;
                }
            }
        }

        protected int hashCode(String string2, String string3) {
            int n2 = string2 == null ? 0 : string2.hashCode();
            return n2 ^ string3.hashCode();
        }
    }
}

