/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String string2) {
        super(string2);
    }

    public SVGPaintManager(String string2, Value value) {
        super(string2, value);
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 7;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return SVGValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lexicalUnit, cSSEngine);
            }
            case 24: 
        }
        String string2 = lexicalUnit.getStringValue();
        String string3 = SVGPaintManager.resolveURI(cSSEngine.getCSSBaseURI(), string2);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit == null) {
            return new URIValue(string2, string3);
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(new URIValue(string2, string3));
        if (lexicalUnit.getLexicalUnitType() == 35 && lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
            listValue.append(SVGValueConstants.NONE_VALUE);
            return listValue;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if (value.getCssValueType() == 3) {
            ListValue listValue2 = (ListValue)value;
            for (int i2 = 0; i2 < listValue2.getLength(); ++i2) {
                listValue.append(listValue2.item(i2));
            }
        } else {
            listValue.append(value);
        }
        return listValue;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string2, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        ListValue listValue;
        Value value2;
        if (value == SVGValueConstants.NONE_VALUE) {
            return value;
        }
        if (value.getCssValueType() == 2 && (value2 = (listValue = (ListValue)value).item(0)).getPrimitiveType() == 20) {
            value2 = listValue.item(1);
            if (value2 == SVGValueConstants.NONE_VALUE) {
                return value;
            }
            Value value3 = super.computeValue(cSSStylableElement, string2, cSSEngine, n2, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue2 = new ListValue(' ');
                listValue2.append(listValue.item(0));
                listValue2.append(value3);
                if (listValue.getLength() == 3) {
                    listValue2.append(listValue.item(1));
                }
                return listValue2;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string2, cSSEngine, n2, styleMap, value);
    }
}

