/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class StringValue
extends AbstractValue {
    protected String value;
    protected short unitType;

    public static String getCssText(short s2, String string2) {
        switch (s2) {
            case 20: {
                return "url(" + string2 + ')';
            }
            case 19: {
                char c2 = string2.indexOf(34) != -1 ? (char)'\'' : '\"';
                return c2 + string2 + c2;
            }
        }
        return string2;
    }

    public StringValue(short s2, String string2) {
        this.unitType = s2;
        this.value = string2;
    }

    @Override
    public short getPrimitiveType() {
        return this.unitType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof StringValue)) {
            return false;
        }
        StringValue stringValue = (StringValue)object;
        if (this.unitType != stringValue.unitType) {
            return false;
        }
        return this.value.equals(stringValue.value);
    }

    @Override
    public String getCssText() {
        return StringValue.getCssText(this.unitType, this.value);
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.value;
    }

    public String toString() {
        return this.getCssText();
    }
}

