/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class FloatValue
extends AbstractValue {
    protected static final String[] UNITS = new String[]{"", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc", "deg", "rad", "grad", "ms", "s", "Hz", "kHz", ""};
    protected float floatValue;
    protected short unitType;

    public static String getCssText(short s2, float f2) {
        if (s2 < 0 || s2 >= UNITS.length) {
            throw new DOMException(12, "");
        }
        String string2 = String.valueOf(f2);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2 + UNITS[s2 - 1];
    }

    public FloatValue(short s2, float f2) {
        this.unitType = s2;
        this.floatValue = f2;
    }

    @Override
    public short getPrimitiveType() {
        return this.unitType;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getCssText() {
        return FloatValue.getCssText(this.unitType, this.floatValue);
    }

    public String toString() {
        return this.getCssText();
    }
}

