/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

public class StringIntMap {
    protected Entry[] table;
    protected int count;

    public StringIntMap(int n2) {
        this.table = new Entry[n2 - (n2 >> 2) + 1];
    }

    public int get(String string2) {
        int n2 = string2.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(string2)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public void put(String string2, int n2) {
        Entry entry;
        int n3 = string2.hashCode() & Integer.MAX_VALUE;
        int n4 = n3 % this.table.length;
        Entry entry2 = this.table[n4];
        while (entry2 != null) {
            if (entry2.hash == n3 && entry2.key.equals(string2)) {
                entry2.value = n2;
                return;
            }
            entry2 = entry2.next;
        }
        int n5 = this.table.length;
        if (this.count++ >= n5 - (n5 >> 2)) {
            this.rehash();
            n4 = n3 % this.table.length;
        }
        this.table[n4] = entry = new Entry(n3, string2, n2, this.table[n4]);
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected static class Entry {
        public final int hash;
        public String key;
        public int value;
        public Entry next;

        public Entry(int n2, String string2, int n3, Entry entry) {
            this.hash = n2;
            this.key = string2;
            this.value = n3;
            this.next = entry;
        }
    }
}

