/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map values;

    public CSSOMStyleDeclaration(ValueProvider valueProvider, CSSRule cSSRule) {
        this.valueProvider = valueProvider;
        this.parentRule = cSSRule;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    @Override
    public String getCssText() {
        return this.valueProvider.getText();
    }

    @Override
    public void setCssText(String string2) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(string2);
    }

    @Override
    public String getPropertyValue(String string2) {
        Value value = this.valueProvider.getValue(string2);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    @Override
    public CSSValue getPropertyCSSValue(String string2) {
        Value value = this.valueProvider.getValue(string2);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(string2);
    }

    @Override
    public String removeProperty(String string2) throws DOMException {
        String string3 = this.getPropertyValue(string2);
        if (string3.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(string2);
            }
            this.handler.propertyRemoved(string2);
        }
        return string3;
    }

    @Override
    public String getPropertyPriority(String string2) {
        return this.valueProvider.isImportant(string2) ? "important" : "";
    }

    @Override
    public void setProperty(String string2, String string3, String string4) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(string2, string3, string4);
    }

    @Override
    public int getLength() {
        return this.valueProvider.getLength();
    }

    @Override
    public String item(int n2) {
        return this.valueProvider.item(n2);
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSValue getCSSValue(String string2) {
        CSSValue cSSValue = null;
        if (this.values != null) {
            cSSValue = (CSSValue)this.values.get(string2);
        }
        if (cSSValue == null) {
            cSSValue = this.createCSSValue(string2);
            if (this.values == null) {
                this.values = new HashMap(11);
            }
            this.values.put(string2, cSSValue);
        }
        return cSSValue;
    }

    protected CSSValue createCSSValue(String string2) {
        return new StyleDeclarationValue(string2);
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected String property;

        public StyleDeclarationValue(String string2) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationValue.this.getValue();
                }

                @Override
                public void textChanged(String string2) throws DOMException {
                    if (CSSOMStyleDeclaration.this.values == null || CSSOMStyleDeclaration.this.values.get(this) == null || StyleDeclarationValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String string3 = CSSOMStyleDeclaration.this.getPropertyPriority(StyleDeclarationValue.this.property);
                    CSSOMStyleDeclaration.this.handler.propertyChanged(StyleDeclarationValue.this.property, string2, string3);
                }
            });
            this.property = string2;
        }

        @Override
        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }
}

