/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeServicesDB
implements ServicesDB {
    private final LibServices lib;

    public NativeServicesDB(LibServices lib) {
        this.lib = lib;
    }

    public static final NativeServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static final NativeServicesDB load() {
        try {
            LibServices libServices;
            Platform.OS os2 = Platform.getPlatform().getOS();
            if (!(os2.equals((Object)Platform.OS.DARWIN) || os2.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || os2.equals((Object)Platform.OS.LINUX) || os2.equals((Object)Platform.OS.SOLARIS) || os2.equals((Object)Platform.OS.FREEBSD) || os2.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os2.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> hashMap = new HashMap<LibraryOption, CallingConvention>();
                hashMap.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                LibServices options = Library.loadLibrary(LibServices.class, hashMap, "Ws2_32");
            } else {
                String[] stringArray;
                if (os2.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] lib = stringArray;
                libServices = Library.loadLibrary(LibServices.class, lib);
            }
            libServices.getservbyname("bootps", "udp");
            libServices.getservbyport(67, "udp");
            return new NativeServicesDB(libServices);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<Service> getAllServices() {
        void s2;
        ArrayList arrayList = new ArrayList();
        try {
            UnixServent allServices;
            while ((allServices = this.lib.getservent()) != null) {
                s2.add(this.serviceFromNative(allServices));
            }
        }
        finally {
            this.lib.endservent();
        }
        return s2;
    }

    private final Service serviceFromNative(UnixServent s2) {
        int port;
        if (s2 == null) {
            return null;
        }
        int n2 = port = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)s2.port.get()) : s2.port.get();
        if (port < 0) {
            port = (port & Short.MAX_VALUE) + 32768;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = s2.aliases.get();
        List<String> aliases2 = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return s2 != null ? new Service(s2.name.get(), port, s2.proto.get(), aliases2) : null;
    }

    @Override
    public Service getServiceByName(String name, String proto) {
        return this.serviceFromNative(this.lib.getservbyname(name, proto));
    }

    @Override
    public Service getServiceByPort(Integer port, String proto) {
        short nport = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? Short.reverseBytes(port.shortValue()) : port.shortValue();
        return this.serviceFromNative(this.lib.getservbyport(Integer.valueOf(nport), proto));
    }

    public static interface LibServices {
        public UnixServent getservbyname(String var1, String var2);

        public UnixServent getservbyport(Integer var1, String var2);

        public UnixServent getservent();

        public void endservent();
    }

    public static class UnixServent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 port = new Struct.Signed32();
        public final Struct.String proto = new Struct.UTF8StringRef();
    }

    private static final class SingletonHolder {
        public static final NativeServicesDB INSTANCE = NativeServicesDB.load();

        private SingletonHolder() {
        }
    }
}

