/*
 * Decompiled with CFR 0.152.
 */
package javatests;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.python.core.PySet;
import org.python.core.PyTuple;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySetInJavaTest {
    public static Set<Object> createPySetContainingJavaObjects() {
        PySet s2 = new PySet();
        s2.add("value");
        s2.add(new Random());
        return s2;
    }

    public static void testPySetAsJavaSet() {
        PySet s2 = new PySet();
        String v2 = "value";
        PySetInJavaTest.check(s2.add(v2));
        PySetInJavaTest.check(!s2.add(v2));
        String[] asArray = (String[])s2.toArray(new String[0]);
        PySetInJavaTest.check(asArray.length == 1);
        PySetInJavaTest.check(asArray[0] == v2);
        Object[] naiveArray = s2.toArray();
        PySetInJavaTest.check(naiveArray.length == 1);
        PySetInJavaTest.check(naiveArray[0] == v2);
        Random rand = new Random();
        PySetInJavaTest.check(s2.addAll((Collection)Generic.list(rand)));
        PySetInJavaTest.check(!s2.addAll((Collection)Generic.list(rand, v2)));
        naiveArray = s2.toArray();
        PySetInJavaTest.check(naiveArray.length == 2);
        for (Object object : naiveArray) {
            if (object instanceof String) {
                PySetInJavaTest.check(object == v2);
                continue;
            }
            PySetInJavaTest.check(object == rand, "Should be 'value' or rand, not " + object);
        }
        PySetInJavaTest.check(!s2.remove(new Random()), "The Random in the set shouldn't match a new Random");
        PySetInJavaTest.check(s2.remove(rand));
        PySetInJavaTest.check(s2.removeAll((Collection)Generic.list(rand, v2)), "The set should contain v and indicate it removed it");
        PySetInJavaTest.check(s2.isEmpty());
        PySetInJavaTest.check(s2.addAll((Collection)Generic.list(rand, v2)));
        PySetInJavaTest.check(2 == s2.size(), "There should be 2 items, not " + s2.size());
        PySetInJavaTest.check(s2.containsAll((Collection)Generic.list(rand, v2)));
        PySetInJavaTest.check(!s2.containsAll((Collection)Generic.list(rand, v2, "other")));
        PySetInJavaTest.check(s2.retainAll((Collection)Generic.list(rand)));
        PySetInJavaTest.check(!s2.retainAll((Collection)Generic.list(rand)));
        PySetInJavaTest.check(s2.addAll((Collection)Generic.list(rand, v2)));
        PySetInJavaTest.check(2 == s2.size(), "There should be 2 items, not " + s2.size());
        PySetInJavaTest.check(!s2.addAll((Collection)Generic.list(rand, v2)));
        PySetInJavaTest.check(2 == s2.size(), "There should be 2 items, not " + s2.size());
    }

    public static void accessAndRemovePySetItems(Set<Object> items) {
        PySetInJavaTest.check(items instanceof PySet, "The set shouldn't be __tojava'd into " + items.getClass());
        PySetInJavaTest.check(items.size() == 3, "Should be 3 items, not " + items.size());
        PySetInJavaTest.check(items.contains("value"), "The set from Python should contain 'value'");
        PySetInJavaTest.check(!items.contains(new Random()), "The set contains a particular Random");
        Iterator<Object> it = items.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            PySetInJavaTest.check(items.contains(object), "The set should contain all items from its iterator");
            if (object instanceof String) {
                PySetInJavaTest.check(object.equals("value"), "The string should be 'value', not '" + object + "'");
            } else {
                PySetInJavaTest.check(object instanceof Random || object instanceof PyTuple, "The objects in the set should be a String, a Random or a PyTuple, not a " + object.getClass());
            }
            it.remove();
        }
    }

    private static void check(boolean testVal) {
        PySetInJavaTest.check(testVal, "");
    }

    private static void check(boolean testVal, String failMsg) {
        if (!testVal) {
            throw new RuntimeException(failMsg);
        }
    }
}

