/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.handler;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.ROWID;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyObject;

public class OracleDataHandler
extends FilterDataHandler {
    public OracleDataHandler(DataHandler datahandler) {
        super(datahandler);
    }

    public String getMetaDataName(PyObject name) {
        String metaName = super.getMetaDataName(name);
        return metaName == null ? null : metaName.toUpperCase();
    }

    public void setJDBCObject(PreparedStatement stmt2, int index, PyObject object, int type) throws SQLException {
        if (DataHandler.checkNull(stmt2, index, object, type)) {
            return;
        }
        switch (type) {
            case 91: {
                Timestamp timestamp = (Timestamp)object.__tojava__(Timestamp.class);
                if (timestamp != Py.NoConversion) {
                    stmt2.setTimestamp(index, timestamp);
                    break;
                }
                super.setJDBCObject(stmt2, index, object, type);
                break;
            }
            case 3: {
                Object input = object.__tojava__(Double.class);
                if (input != Py.NoConversion) {
                    stmt2.setDouble(index, (Double)input);
                    break;
                }
                super.setJDBCObject(stmt2, index, object, type);
                break;
            }
            case 2: {
                super.setJDBCObject(stmt2, index, object, 8);
                break;
            }
            case -8: {
                stmt2.setString(index, (String)object.__tojava__(String.class));
                break;
            }
            case -102: 
            case -101: {
                super.setJDBCObject(stmt2, index, object, 93);
                break;
            }
            default: {
                super.setJDBCObject(stmt2, index, object, type);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case 91: {
                obj = Py.newDatetime(set.getTimestamp(col));
                break;
            }
            case 2: {
                int precision;
                int sqle;
                String number = set.getString(col);
                if (number == null) {
                    obj = Py.None;
                    break;
                }
                try {
                    void scale;
                    ResultSetMetaData resultSetMetaData = set.getMetaData();
                    int n2 = resultSetMetaData.getScale(col);
                    int metaData = scale.getPrecision(col);
                }
                catch (SQLException scale) {
                    sqle = 0;
                    precision = 0;
                }
                if (precision == -127) {
                    if (sqle == 0) {
                        obj = number.indexOf(46) == -1 ? PyInteger.TYPE.__call__(Py.newString(number)) : Py.newDecimal(number);
                        break;
                    }
                    obj = Py.newFloat(set.getBigDecimal(col).doubleValue());
                    break;
                }
                obj = precision == 0 && (sqle != 0 || number.indexOf(46) == -1) ? PyInteger.TYPE.__call__(Py.newString(number)) : Py.newDecimal(number);
                break;
            }
            case 2004: {
                BLOB scale = ((OracleResultSet)set).getBLOB(col);
                obj = scale == null ? Py.None : Py.java2py(OracleDataHandler.read(scale.getBinaryStream()));
                break;
            }
            case -102: 
            case -101: {
                obj = super.getPyObject(set, col, 93);
                break;
            }
            case -8: {
                ROWID rowid = ((OracleResultSet)set).getROWID(col);
                if (rowid == null) break;
                obj = Py.java2py(rowid.stringValue());
                break;
            }
            default: {
                obj = super.getPyObject(set, col, type);
            }
        }
        return set.wasNull() ? Py.None : obj;
    }

    public void registerOut(CallableStatement statement, int index, int colType, int dataType, String dataTypeName) throws SQLException {
        if (dataType == 1111) {
            if ("REF CURSOR".equals(dataTypeName)) {
                statement.registerOutParameter(index, -10);
                return;
            }
            if ("PL/SQL RECORD".equals(dataTypeName)) {
                statement.registerOutParameter(index, -10);
                return;
            }
        }
        super.registerOut(statement, index, colType, dataType, dataTypeName);
    }
}

