/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.lang.reflect.Method;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "RangeSliderUI";
    private boolean _rangeDraggable = true;
    public static final String CLIENT_PROPERTY_MOUSE_POSITION = "RangeSlider.mousePosition";
    public static final String CLIENT_PROPERTY_ADJUST_ACTION = "RangeSlider.adjustAction";
    public static final String PROPERTY_LOW_VALUE = "lowValue";
    public static final String PROPERTY_HIGH_VALUE = "highValue";

    public RangeSlider() {
    }

    public RangeSlider(int orientation) {
        super(orientation);
    }

    public RangeSlider(int min, int max) {
        super(min, max);
    }

    public RangeSlider(int min, int max, int low, int high) {
        super(new DefaultBoundedRangeModel(low, high - low, min, max));
        this.getModel().removeChangeListener(this.changeListener);
        this.getModel().removeChangeListener(this.changeListener);
        this.getModel().addChangeListener(this.changeListener);
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> uiClass = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> acClass = JComponent.class;
            Method m2 = uiClass.getMethod("createUI", acClass);
            if (m2 != null) {
                Object uiObject = m2.invoke(null, this);
                this.setUI((ComponentUI)uiObject);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int value) {
        return value >= this.getLowValue() && value <= this.getHighValue();
    }

    public void setValue(int value) {
        Object clientProperty = this.getClientProperty(CLIENT_PROPERTY_MOUSE_POSITION);
        if (clientProperty != null) {
            if (Boolean.TRUE.equals(clientProperty)) {
                this.setLowValue(value);
            } else {
                this.setHighValue(value);
            }
        } else {
            this.setLowValue(value);
        }
    }

    public void setLowValue(int lowValue) {
        int old = this.getLowValue();
        int high = lowValue + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int extent = high - lowValue;
        Object property = this.getClientProperty(CLIENT_PROPERTY_ADJUST_ACTION);
        this.getModel().setRangeProperties(lowValue, extent, this.getMinimum(), this.getMaximum(), property == null || !property.equals("scrollByBlock") && !property.equals("scrollByUnit"));
        this.firePropertyChange(PROPERTY_LOW_VALUE, old, this.getLowValue());
    }

    public void setHighValue(int highValue) {
        int old = this.getHighValue();
        this.getModel().setExtent(highValue - this.getLowValue());
        this.firePropertyChange(PROPERTY_HIGH_VALUE, old, this.getHighValue());
    }

    public boolean isRangeDraggable() {
        return this._rangeDraggable;
    }

    public void setRangeDraggable(boolean rangeDraggable) {
        this._rangeDraggable = rangeDraggable;
    }
}

