/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder
implements PartialSide {
    private int _sides = 15;
    private int _roundedCornerSize = 5;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public PartialLineBorder(Color color, int thickness, boolean roundedCorners) {
        super(color, thickness, roundedCorners);
    }

    public PartialLineBorder(Color color, int thickness, boolean roundedCorners, int roundedCornerSize) {
        super(color, thickness, roundedCorners);
        this._roundedCornerSize = roundedCornerSize;
    }

    public PartialLineBorder(Color color, int thickness, int side) {
        super(color, thickness);
        this._sides = side;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public int getRoundedCornerSize() {
        return this._roundedCornerSize;
    }

    public void setRoundedCornerSize(int roundedCornerSize) {
        this._roundedCornerSize = roundedCornerSize;
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Color oldColor = g2.getColor();
        g2.setColor(this.lineColor);
        for (int i2 = 0; i2 < this.thickness; ++i2) {
            if (this._sides == 15) {
                if (!this.roundedCorners) {
                    g2.drawRect(x2 + i2, y2 + i2, width - i2 - i2 - 1, height - i2 - i2 - 1);
                    continue;
                }
                Object o2 = JideSwingUtilities.setupShapeAntialiasing(g2);
                g2.drawRoundRect(x2 + i2, y2 + i2, width - i2 - i2 - 1, height - i2 - i2 - 1, this._roundedCornerSize, this._roundedCornerSize);
                JideSwingUtilities.restoreShapeAntialiasing(g2, o2);
                continue;
            }
            if ((this._sides & 1) != 0) {
                g2.drawLine(x2, y2 + i2, x2 + width - 1, y2 + i2);
            }
            if ((this._sides & 2) != 0) {
                g2.drawLine(x2, y2 + height - i2 - 1, x2 + width - 1, y2 + height - i2 - 1);
            }
            if ((this._sides & 8) != 0) {
                g2.drawLine(x2 + i2, y2, x2 + i2, y2 + height - 1);
            }
            if ((this._sides & 4) == 0) continue;
            g2.drawLine(x2 + width - i2 - 1, y2, x2 + width - i2 - 1, y2 + height - 1);
        }
        g2.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c2) {
        Insets borderInsets = super.getBorderInsets(c2);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c2, insets);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }
}

