/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class PartialGradientLineBorder
extends AbstractBorder
implements PartialSide {
    private int _sides = 15;
    private Color[] _colors;
    protected int _thickness;

    public PartialGradientLineBorder(Color[] colors2) {
        this(colors2, 1);
    }

    public PartialGradientLineBorder(Color[] colors2, int thickness) {
        this(colors2, thickness, 15);
    }

    public PartialGradientLineBorder(Color[] colors2, int thickness, int sides) {
        if (colors2.length < 2) {
            throw new IllegalArgumentException("Array \"colors\" should have at least 2 elements.");
        }
        this._colors = colors2;
        this._thickness = thickness;
        this._sides = sides;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Color oldColor = g2.getColor();
        Graphics2D g2d = (Graphics2D)g2;
        int i2 = 0;
        if ((this._sides & 1) != 0) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x2, y2, width, this._thickness), this._colors[i2++], this._colors[i2++], false);
        }
        if ((this._sides & 2) != 0) {
            if (i2 >= this._colors.length) {
                i2 -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x2, y2 + height - this._thickness, width, this._thickness), this._colors[i2++], this._colors[i2++], false);
        }
        if ((this._sides & 8) != 0) {
            if (i2 >= this._colors.length) {
                i2 -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x2, y2, this._thickness, height), this._colors[i2++], this._colors[i2++], true);
        }
        if ((this._sides & 4) != 0) {
            if (i2 >= this._colors.length) {
                i2 -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x2 + width - this._thickness, y2, this._thickness, height), this._colors[i2++], this._colors[i2], true);
        }
        g2.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c2) {
        Insets borderInsets = super.getBorderInsets(c2);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c2, insets);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }
}

