/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.OverlayableIconsFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;

public class OverlayableUtils {
    public static Overlayable getOverlayable(JComponent component) {
        Container parent = component;
        do {
            Object o2;
            if (!((o2 = parent.getClientProperty("Overlayable.overlayable")) instanceof Overlayable)) continue;
            return (Overlayable)o2;
        } while ((parent = parent.getParent()) instanceof JComponent);
        return null;
    }

    public static Overlayable[] getAllOverlayables(JComponent component) {
        ArrayList<Overlayable> list = new ArrayList<Overlayable>();
        Container parent = component;
        do {
            Object o2;
            if (!((o2 = parent.getClientProperty("Overlayable.overlayable")) instanceof Overlayable) || list.contains(o2)) continue;
            list.add((Overlayable)o2);
        } while ((parent = parent.getParent()) != null);
        return list.toArray(new Overlayable[list.size()]);
    }

    public static void repaintOverlayable(JComponent component) {
        Overlayable overlayable = OverlayableUtils.getOverlayable(component);
        if (overlayable != null && overlayable instanceof Component) {
            ((Component)((Object)overlayable)).repaint();
        }
    }

    public static void repaintAllOverlayables(JComponent component) {
        Overlayable[] overlayables;
        for (Overlayable overlayable : overlayables = OverlayableUtils.getAllOverlayables(component)) {
            if (overlayable == null || !(overlayable instanceof Component)) continue;
            ((Component)((Object)overlayable)).repaint();
        }
    }

    public static Icon getPredefinedOverlayIcon(String name) {
        return OverlayableIconsFactory.getImageIcon(name);
    }
}

