/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.beans.ConstructorProperties;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JideTitledBorder
extends AbstractBorder {
    private static final long serialVersionUID = 5409659168893849250L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private final JLabel label;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 0;

    public JideTitledBorder(String title) {
        this(null, title, 4, 0, null, null);
    }

    public JideTitledBorder(Border border) {
        this(border, "", 4, 0, null, null);
    }

    public JideTitledBorder(Border border, String title) {
        this(border, title, 4, 0, null, null);
    }

    public JideTitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public JideTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    @ConstructorProperties(value={"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"})
    public JideTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.title = title;
        this.border = border;
        this.titleFont = titleFont;
        this.titleColor = titleColor;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
        this.label = new JLabel();
        this.label.setOpaque(false);
        this.label.putClientProperty("html", null);
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Border border = this.getBorderUI();
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            int edge = border instanceof JideTitledBorder ? 0 : 2;
            JLabel label = this.getLabel(c2);
            Dimension size = label.getPreferredSize();
            Insets insets = border != null ? border.getBorderInsets(c2) : new Insets(0, 0, 0, 0);
            int borderX = x2 + edge;
            int borderY = y2 + edge;
            int borderW = width - edge - edge;
            int borderH = height - edge - edge;
            int labelY = y2;
            int labelH = size.height;
            int position = this.getPosition();
            switch (position) {
                case 1: {
                    insets.left = 0;
                    insets.right = 0;
                    borderY += labelH - edge;
                    borderH -= labelH - edge;
                    break;
                }
                case 2: {
                    insets.top = edge + insets.top / 2 - labelH / 2;
                    if (insets.top < edge) {
                        borderY -= insets.top;
                        borderH += insets.top;
                        break;
                    }
                    labelY += insets.top;
                    break;
                }
                case 3: {
                    labelY += insets.top + edge;
                    break;
                }
                case 4: {
                    labelY += height - labelH - insets.bottom - edge;
                    break;
                }
                case 5: {
                    labelY += height - labelH;
                    insets.bottom = edge + (insets.bottom - labelH) / 2;
                    if (insets.bottom < edge) {
                        borderH += insets.bottom;
                        break;
                    }
                    labelY -= insets.bottom;
                    break;
                }
                case 6: {
                    insets.left = 0;
                    insets.right = 0;
                    labelY += height - labelH;
                    borderH -= labelH - edge;
                }
            }
            insets.left += edge + 0;
            insets.right += edge + 0;
            int labelX = x2;
            int labelW = width - insets.left - insets.right;
            if (labelW > size.width) {
                labelW = size.width;
            }
            switch (this.getJustification(c2)) {
                case 1: {
                    labelX += insets.left;
                    break;
                }
                case 3: {
                    labelX += width - insets.right - labelW;
                    break;
                }
                case 2: {
                    labelX += (width - labelW) / 2;
                }
            }
            if (border != null) {
                if (position != 2 && position != 5) {
                    border.paintBorder(c2, g2, borderX, borderY, borderW, borderH);
                } else {
                    Graphics g22 = g2.create();
                    if (g22 instanceof Graphics2D) {
                        Graphics2D g2d = (Graphics2D)g22;
                        Path2D.Float path = new Path2D.Float();
                        path.append(new Rectangle(borderX, borderY, borderW, labelY - borderY), false);
                        path.append(new Rectangle(borderX, labelY, labelX - borderX - 2, labelH), false);
                        path.append(new Rectangle(labelX + labelW + 2, labelY, borderX - labelX + borderW - labelW - 2, labelH), false);
                        path.append(new Rectangle(borderX, labelY + labelH, borderW, borderY - labelY + borderH - labelH), false);
                        g2d.clip(path);
                    }
                    border.paintBorder(c2, g22, borderX, borderY, borderW, borderH);
                    g22.dispose();
                }
            }
            g2.translate(labelX, labelY);
            label.setSize(labelW, labelH);
            label.paint(g2);
            g2.translate(-labelX, -labelY);
        } else if (border != null) {
            border.paintBorder(c2, g2, x2, y2, width, height);
        }
    }

    public Insets getBorderInsets(Component c2) {
        return this.getBorderInsets(c2, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c2, Insets insets) {
        Border border = this.getBorderUI();
        if (border == null) {
            insets.set(0, 0, 0, 0);
        } else if (border instanceof AbstractBorder) {
            AbstractBorder ab2 = (AbstractBorder)border;
            insets = ab2.getBorderInsets(c2, insets);
        } else {
            Insets i2 = border.getBorderInsets(c2);
            insets.set(i2.top, i2.left, i2.bottom, i2.right);
        }
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            int edge = border instanceof JideTitledBorder ? 0 : 2;
            JLabel label = this.getLabel(c2);
            Dimension size = label.getPreferredSize();
            switch (this.getPosition()) {
                case 1: {
                    insets.top += size.height - edge;
                    break;
                }
                case 2: {
                    if (insets.top >= size.height) break;
                    insets.top = size.height - edge;
                    break;
                }
                case 3: {
                    insets.top += size.height;
                    break;
                }
                case 4: {
                    insets.bottom += size.height;
                    break;
                }
                case 5: {
                    if (insets.bottom >= size.height) break;
                    insets.bottom = size.height - edge;
                    break;
                }
                case 6: {
                    insets.bottom += size.height - edge;
                }
            }
            insets.top += edge + 2;
            insets.left += edge + 2;
            insets.right += edge + 2;
            insets.bottom += edge + 2;
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        return this.border;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        switch (titlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = titlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(titlePosition + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int titleJustification) {
        switch (titleJustification) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = titleJustification;
                break;
            }
            default: {
                throw new IllegalArgumentException(titleJustification + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c2) {
        Insets insets = this.getBorderInsets(c2);
        Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            JLabel label = this.getLabel(c2);
            Dimension size = label.getPreferredSize();
            int position = this.getPosition();
            if (position != 1 && position != 6) {
                minSize.width += size.width;
            } else if (minSize.width < size.width) {
                minSize.width += size.width;
            }
        }
        return minSize;
    }

    public int getBaseline(Component c2, int width, int height) {
        if (c2 == null) {
            throw new NullPointerException("Must supply non-null component");
        }
        if (width < 0) {
            throw new IllegalArgumentException("Width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height must be >= 0");
        }
        Border border = this.getBorderUI();
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            int edge = border instanceof JideTitledBorder ? 0 : 2;
            JLabel label = this.getLabel(c2);
            Dimension size = label.getPreferredSize();
            Insets insets = border != null ? border.getBorderInsets(c2) : new Insets(0, 0, 0, 0);
            int baseline = label.getBaseline(size.width, size.height);
            switch (this.getPosition()) {
                case 1: {
                    return baseline;
                }
                case 2: {
                    insets.top = edge + (insets.top - size.height) / 2;
                    return insets.top < edge ? baseline : baseline + insets.top;
                }
                case 3: {
                    return baseline + insets.top + edge;
                }
                case 4: {
                    return baseline + height - size.height - insets.bottom - edge;
                }
                case 5: {
                    insets.bottom = edge + (insets.bottom - size.height) / 2;
                    return insets.bottom < edge ? baseline + height - size.height : baseline + height - size.height + insets.bottom;
                }
                case 6: {
                    return baseline + height - size.height;
                }
            }
        }
        return -1;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component c2) {
        super.getBaselineResizeBehavior(c2);
        switch (this.getPosition()) {
            case 1: 
            case 2: 
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 4: 
            case 5: 
            case 6: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    private Border getBorderUI() {
        Border border = this.getBorder();
        return border != null ? border : UIManager.getBorder("TitledBorder.border");
    }

    private int getPosition() {
        int position = this.getTitlePosition();
        if (position != 0) {
            return position;
        }
        Object value = UIManager.get("TitledBorder.position");
        if (value instanceof Integer) {
            int i2 = (Integer)value;
            if (0 < i2 && i2 <= 6) {
                return i2;
            }
        } else if (value instanceof String) {
            String s2 = (String)value;
            if (s2.equalsIgnoreCase("ABOVE_TOP")) {
                return 1;
            }
            if (s2.equalsIgnoreCase("TOP")) {
                return 2;
            }
            if (s2.equalsIgnoreCase("BELOW_TOP")) {
                return 3;
            }
            if (s2.equalsIgnoreCase("ABOVE_BOTTOM")) {
                return 4;
            }
            if (s2.equalsIgnoreCase("BOTTOM")) {
                return 5;
            }
            if (s2.equalsIgnoreCase("BELOW_BOTTOM")) {
                return 6;
            }
        }
        return 2;
    }

    private int getJustification(Component c2) {
        int justification = this.getTitleJustification();
        if (justification == 4 || justification == 0) {
            return c2.getComponentOrientation().isLeftToRight() ? 1 : 3;
        }
        if (justification == 5) {
            return c2.getComponentOrientation().isLeftToRight() ? 3 : 1;
        }
        return justification;
    }

    protected Font getFont(Component c2) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        font = UIManager.getFont("TitledBorder.font");
        if (font != null) {
            return font;
        }
        if (c2 != null && (font = c2.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private Color getColor(Component c2) {
        Color color = this.getTitleColor();
        if (color != null) {
            return color;
        }
        color = UIManager.getColor("TitledBorder.titleColor");
        if (color != null) {
            return color;
        }
        return c2 != null ? c2.getForeground() : null;
    }

    private JLabel getLabel(Component c2) {
        this.label.setText(this.getTitle());
        this.label.setFont(this.getFont(c2));
        this.label.setForeground(this.getColor(c2));
        this.label.setComponentOrientation(c2.getComponentOrientation());
        this.label.setEnabled(c2.isEnabled());
        return this.label;
    }
}

