/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    private int _dividerStepSize = 0;
    private boolean _dragResizable = true;
    private boolean _hiddenByMyself = false;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int newOrientation) {
        this._orientation = newOrientation;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout layoutManager = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(layoutManager);
        this.setOpaque(false);
        this.installListeners();
    }

    public int getDividerStepSize() {
        return this._dividerStepSize;
    }

    public void setDividerStepSize(int dividerStepSize) {
        if (dividerStepSize < 0) {
            return;
        }
        this._dividerStepSize = dividerStepSize;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int newSize) {
        int oldSize = this._dividerSize;
        if (oldSize != newSize) {
            this._dividerSize = newSize;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, oldSize, newSize);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Component insertPane(Component pane, int index) {
        return this.insertPane(pane, null, index);
    }

    public Component insertPane(Component pane, Object constraint, int index) {
        if (index <= 0) {
            this.addImpl(pane, constraint, 0);
        } else if (index >= this.getPaneCount()) {
            this.addImpl(pane, constraint, -1);
        } else {
            this.addImpl(pane, constraint, (index << 1) - 1);
        }
        return pane;
    }

    public Component addPane(Component pane) {
        if (pane == null) {
            return null;
        }
        return super.add(pane);
    }

    public void removePane(Component pane) {
        this.removePane(this.indexOfPane(pane));
    }

    public void setPaneAt(Component pane, int index) {
        this.setPaneAt(pane, null, index);
    }

    public void setPaneAt(Component pane, Object constraint, int index) {
        double[] proportions = this._proportions;
        this._proportions = null;
        this.removePane(index);
        this.insertPane(pane, constraint, index);
        this._proportions = proportions;
        this.validate();
    }

    public void removePane(int index) {
        if (index == 0) {
            super.remove(0);
        } else {
            super.remove(index << 1);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == orientation) {
            return;
        }
        int oldOrientation = this._orientation;
        this._orientation = orientation;
        JideSplitPaneLayout layoutManager = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        Component[] components = this.getComponents();
        LayoutManager oldManager = this.getLayout();
        Map<Component, Object> constraintMap = null;
        if (oldManager instanceof JideSplitPaneLayout) {
            constraintMap = ((JideSplitPaneLayout)oldManager).getConstraintMap();
        }
        if (components != null && constraintMap != null) {
            for (Component comp : components) {
                layoutManager.addLayoutComponent(comp, constraintMap.get(comp));
            }
        }
        super.setLayout(layoutManager);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, oldOrientation, orientation);
    }

    public int getOrientation() {
        return this._orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToPreferredSizes() {
        if (this.getLayout() instanceof JideBoxLayout) {
            boolean old = ((JideBoxLayout)this.getLayout()).isResetWhenInvalidate();
            try {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(true);
                ((JideBoxLayout)this.getLayout()).invalidateLayout(this);
            }
            finally {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(old);
            }
        }
        this.doLayout();
    }

    public void setProportionalLayout(boolean proportionalLayout) {
        if (proportionalLayout == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = proportionalLayout;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !proportionalLayout, proportionalLayout);
        if (!proportionalLayout) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    void internalSetProportions(double[] proportions) {
        this._proportions = proportions;
    }

    public void setProportions(double[] proportions) {
        if (!this._proportionalLayout && proportions != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(proportions, this._proportions)) {
            return;
        }
        if (proportions != null && proportions.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + proportions.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (proportions != null) {
            double sum = 0.0;
            for (int i2 = 0; i2 < proportions.length; ++i2) {
                if (proportions[i2] < 0.0) {
                    proportions[i2] = 0.0;
                }
                if (proportions[i2] > 1.0) {
                    proportions[i2] = 1.0;
                }
                sum += proportions[i2];
            }
            if (sum > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + sum);
            }
        }
        double[] oldProportions = this._proportions;
        this._proportions = proportions == null ? null : (double[])proportions.clone();
        LayoutManager layoutManager = this.getLayout();
        boolean reset = false;
        if (layoutManager instanceof JideBoxLayout) {
            reset = ((JideBoxLayout)layoutManager).isResetWhenInvalidate();
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (reset) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(reset);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, oldProportions, proportions);
    }

    public double[] getProportions() {
        double[] answer = this._proportions;
        if (answer != null) {
            answer = (double[])answer.clone();
        }
        return answer;
    }

    public void setInitiallyEven(boolean initiallyEven) {
        this._initiallyEven = initiallyEven;
    }

    public boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider divider) {
        if (!this.isContinuousLayout()) {
            Container topLevelAncestor = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    public void windowDeactivated(WindowEvent e2) {
                        JideSplitPane.this.stopDragging();
                        if (e2.getWindow() != null) {
                            e2.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (topLevelAncestor instanceof Window) {
                ((Window)topLevelAncestor).addWindowListener(this._windowDeactivatedListener);
            }
            if (topLevelAncestor instanceof RootPaneContainer) {
                this._layeredPane = ((RootPaneContainer)((Object)topLevelAncestor)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    JideSplitPaneContour nonContinuousLayoutDivider = new JideSplitPaneContour();
                    this._nonContinuousLayoutDividerWrapper = new JideSplitPaneHeavyweightWrapper(nonContinuousLayoutDivider);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                Rectangle bounds = this.getVisibleRect();
                Rectangle layeredPaneBounds = SwingUtilities.convertRectangle(this, bounds, this._layeredPane);
                int dividerThickness = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(layeredPaneBounds.x, layeredPaneBounds.y, dividerThickness, layeredPaneBounds.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(layeredPaneBounds.x, layeredPaneBounds.y, layeredPaneBounds.width, dividerThickness);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            Component[] childComponents;
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
            for (Component component : childComponents = this._layeredPane.getComponents()) {
                if (!(component instanceof JideSplitPaneContour) && !(component instanceof JideSplitPaneHeavyweightWrapper)) continue;
                this._layeredPane.remove(component);
            }
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider divider, int location) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(divider, location);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point p2;
            Dimension size = new Dimension();
            Rectangle rect = this.getVisibleRect();
            int dividerThickness = Math.min(4, this.getDividerSize());
            Rectangle convertedRect = SwingUtilities.convertRectangle(this, rect, this._layeredPane);
            if (this.getOrientation() == 1) {
                p2 = SwingUtilities.convertPoint(this, location, rect.y, this._layeredPane);
                p2.x += this.getDividerSize() - dividerThickness >> 1;
                size.width = dividerThickness;
                size.height = convertedRect.height;
            } else {
                p2 = SwingUtilities.convertPoint(this, rect.x, location, this._layeredPane);
                p2.y += this.getDividerSize() - dividerThickness >> 1;
                size.width = convertedRect.width;
                size.height = dividerThickness;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetBounds(new Rectangle(p2, size));
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider divider, int location) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(divider, location);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider divider) {
        int index = this.indexOf(divider);
        if (index == -1) {
            return index;
        }
        if (index % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + index + ")");
        }
        return (index - 1) / 2;
    }

    public int indexOfPane(Component pane) {
        int index = this.indexOf(pane);
        if (index == -1) {
            return -1;
        }
        if (index % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + index + ")");
        }
        return index >> 1;
    }

    public int indexOf(Component comp) {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            if (!this.getComponent(i2).equals(comp)) continue;
            return i2;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int index) {
        if (index < 0 || index * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(index * 2 + 1);
    }

    public Component getPaneAt(int index) {
        if (index < 0 || index << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(index << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider divider, int location) {
        this.setDividerLocation(this.indexOfDivider(divider), location);
    }

    public void setDividerLocation(int dividerIndex, int location) {
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(dividerIndex, location, true);
        this.validate();
    }

    public int getDividerLocation(int dividerIndex) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(dividerIndex);
    }

    public void componentAdded(ContainerEvent e2) {
        e2.getChild().addComponentListener(this);
        if (!(e2.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
            if (this.isOneTouchExpandable()) {
                e2.getChild().setMinimumSize(new Dimension(0, 0));
            }
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentRemoved(ContainerEvent e2) {
        e2.getChild().removeComponentListener(this);
        if (!(e2.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentResized(ComponentEvent e2) {
    }

    public void componentMoved(ComponentEvent e2) {
    }

    public void componentShown(ComponentEvent e2) {
        if (e2.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentHidden(ComponentEvent e2) {
        if (e2.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int extra = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean changed = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(0)).setJideSplitPane(null);
            this.remove(0);
            this.removeProportion(0);
            changed = true;
        }
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component comp = this.getComponent(i2);
            if (comp instanceof JideSplitPaneDivider) {
                if (++extra != 2) continue;
                comp = this.getComponent(i2 - 1);
                ((JideSplitPaneDivider)comp).setJideSplitPane(null);
                this.remove(comp);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i2 / 2);
                }
                changed = true;
                --extra;
                --i2;
                continue;
            }
            extra = 0;
        }
        if (extra == 1 && this.getComponent(this.getComponentCount() - 1) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(this.getComponentCount() - 1)).setJideSplitPane(null);
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            changed = true;
        }
        return changed;
    }

    protected void removeProportion(int paneIndex) {
        double p2;
        double[] oldProportions = this._proportions;
        if (oldProportions == null) {
            return;
        }
        if (oldProportions.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] newProportions = new double[oldProportions.length - 1];
        if (paneIndex < oldProportions.length) {
            p2 = oldProportions[paneIndex];
        } else {
            p2 = 1.0;
            for (double proportion : oldProportions) {
                p2 -= proportion;
            }
        }
        double total = 1.0 - p2;
        for (int i2 = 0; i2 < newProportions.length; ++i2) {
            int j2 = i2 < paneIndex ? i2 : i2 + 1;
            newProportions[i2] = oldProportions[j2] / total;
        }
        if (newProportions.length == 1) {
            // empty if block
        }
        this.setProportions(newProportions);
    }

    protected void addExtraDividers() {
        int extra = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component comp = this.getComponent(i2);
            if (!(comp instanceof JideSplitPaneDivider)) {
                if (++extra != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i2);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i2 + 1) / 2);
                }
                extra = 0;
                continue;
            }
            extra = 0;
        }
    }

    protected void addProportion(int paneIndex) {
        double[] oldProportions = this._proportions;
        if (oldProportions == null) {
            return;
        }
        double[] newProportions = new double[oldProportions.length + 1];
        double p2 = 1.0 / (double)(newProportions.length + 1);
        double total = 1.0 - p2;
        for (int i2 = 0; i2 < newProportions.length; ++i2) {
            if (i2 == paneIndex) {
                newProportions[i2] = p2;
                continue;
            }
            int j2 = i2 < paneIndex ? i2 : i2 - 1;
            newProportions[i2] = j2 < oldProportions.length ? oldProportions[j2] * total : p2;
        }
        this.setProportions(newProportions);
    }

    public void setVisible(boolean aFlag) {
        this._hiddenByMyself = false;
        super.setVisible(aFlag);
    }

    protected void setDividersVisible() {
        boolean anyVisible = false;
        if (this.getComponentCount() == 1) {
            anyVisible = this.getComponent(0).isVisible();
        } else if (this.getComponentCount() > 1) {
            boolean anyPrevVisible = false;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                boolean visibleNext;
                Component comp = this.getComponent(i2);
                if (!(comp instanceof JideSplitPaneDivider)) {
                    if (!comp.isVisible() || anyVisible) continue;
                    anyVisible = true;
                    continue;
                }
                boolean visiblePrev = i2 - 1 >= 0 && this.getComponent(i2 - 1).isVisible();
                boolean bl2 = visibleNext = i2 + 1 < this.getComponentCount() && this.getComponent(i2 + 1).isVisible();
                if (visiblePrev && visibleNext) {
                    comp.setVisible(true);
                    continue;
                }
                if (!visiblePrev && !visibleNext) {
                    comp.setVisible(false);
                    continue;
                }
                if (visiblePrev && !visibleNext) {
                    comp.setVisible(false);
                    anyPrevVisible = true;
                    continue;
                }
                if (anyPrevVisible) {
                    comp.setVisible(true);
                    anyPrevVisible = false;
                    continue;
                }
                comp.setVisible(false);
            }
        }
        if (!anyVisible) {
            super.setVisible(false);
            this._hiddenByMyself = true;
        } else if (this._hiddenByMyself) {
            super.setVisible(true);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider divider, boolean ignoreVisibility, boolean reversed) {
        int index = this.indexOfDivider(divider);
        int location = -1;
        if (reversed) {
            if ((index + 1) * 2 + 1 <= this.getComponentCount()) {
                int i2 = index + 1;
                while (i2 * 2 + 1 < this.getComponentCount()) {
                    if (ignoreVisibility || this.getDividerAt(i2).isVisible()) {
                        location = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                        break;
                    }
                    ++i2;
                }
            }
        } else if (index > 0) {
            for (int i3 = index - 1; i3 >= 0; --i3) {
                if (!ignoreVisibility && !this.getDividerAt(i3).isVisible()) continue;
                location = this._orientation == 1 ? this.getDividerAt((int)i3).getBounds().x : this.getDividerAt((int)i3).getBounds().y;
                break;
            }
        }
        if (location != -1) {
            return location + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider divider, boolean ignoreVisibility, boolean reversed) {
        int index = this.indexOfDivider(divider);
        int location = -1;
        if (!reversed) {
            if ((index + 1) * 2 + 1 <= this.getComponentCount()) {
                int i2 = index + 1;
                while (i2 * 2 + 1 < this.getComponentCount()) {
                    if (ignoreVisibility || this.getDividerAt(i2).isVisible()) {
                        location = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                        break;
                    }
                    ++i2;
                }
            }
        } else if (index > 0) {
            for (int i3 = index - 1; i3 >= 0; --i3) {
                if (!ignoreVisibility && !this.getDividerAt(i3).isVisible()) continue;
                location = this._orientation == 1 ? this.getDividerAt((int)i3).getBounds().x : this.getDividerAt((int)i3).getBounds().y;
                break;
            }
        }
        if (location != -1) {
            return location - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean showGripper) {
        boolean oldShowGripper = this._showGripper;
        if (oldShowGripper != showGripper) {
            this._showGripper = showGripper;
            this.firePropertyChange(GRIPPER_PROPERTY, oldShowGripper, this._showGripper);
        }
    }

    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public void setContinuousLayout(boolean continuousLayout) {
        boolean oldCD = this._continuousLayout;
        this._continuousLayout = continuousLayout;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, oldCD, continuousLayout);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isDragResizable() {
        return this._dragResizable;
    }

    public void setDragResizable(boolean dragResizable) {
        this._dragResizable = dragResizable;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean heavyweightComponentEnabled) {
        boolean old = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != heavyweightComponentEnabled) {
            this._heavyweightComponentEnabled = heavyweightComponentEnabled;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, old, this._heavyweightComponentEnabled);
        }
    }

    public void setOneTouchExpandable(boolean oneTouchExpandable) {
        boolean oldValue = this._oneTouchExpandable;
        if (oldValue != oneTouchExpandable) {
            this._oneTouchExpandable = oneTouchExpandable;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (oneTouchExpandable) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, oldValue, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon leftButtonImageIcon) {
        this._leftOneTouchButtonImageIcon = leftButtonImageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon rightButtonImageIcon) {
        this._rightOneTouchButtonImageIcon = rightButtonImageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public void setDividerLocations(int[] locations) {
        for (int i2 = 0; i2 < locations.length; ++i2) {
            int location = locations[i2];
            this.setDividerLocation(i2, location);
        }
    }

    public int[] getDividerLocations() {
        int count = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] locations = new int[count - 1];
        for (int i2 = 0; i2 < count - 1; ++i2) {
            locations[i2] = this.getDividerLocation(i2);
        }
        return locations;
    }

    private class JideSplitPaneHeavyweightWrapper
    extends HeavyweightWrapper {
        public JideSplitPaneHeavyweightWrapper(Component component) {
            super(component);
        }
    }

    private class JideSplitPaneContour
    extends Contour {
        public JideSplitPaneContour() {
        }

        public JideSplitPaneContour(int tabHeight) {
            super(tabHeight);
        }
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = -6167624875135108683L;

        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

