/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class JideBorderLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;
    Component firstLine;
    Component lastLine;
    Component firstItem;
    Component lastItem;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;

    public JideBorderLayout() {
        this(0, 0);
    }

    public JideBorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = CENTER;
            }
            if (CENTER.equals(name)) {
                this.center = comp;
            } else if (NORTH.equals(name)) {
                this.north = comp;
            } else if (SOUTH.equals(name)) {
                this.south = comp;
            } else if (EAST.equals(name)) {
                this.east = comp;
            } else if (WEST.equals(name)) {
                this.west = comp;
            } else if ("First".equals(name)) {
                this.firstLine = comp;
            } else if ("Last".equals(name)) {
                this.lastLine = comp;
            } else if ("Before".equals(name)) {
                this.firstItem = comp;
            } else if ("After".equals(name)) {
                this.lastItem = comp;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.center) {
                this.center = null;
            } else if (comp == this.north) {
                this.north = null;
            } else if (comp == this.south) {
                this.south = null;
            } else if (comp == this.east) {
                this.east = null;
            } else if (comp == this.west) {
                this.west = null;
            }
            if (comp == this.firstLine) {
                this.firstLine = null;
            } else if (comp == this.lastLine) {
                this.lastLine = null;
            } else if (comp == this.firstItem) {
                this.firstItem = null;
            } else if (comp == this.lastItem) {
                this.lastItem = null;
            }
        }
    }

    public Component getLayoutComponent(Object constraints) {
        if (CENTER.equals(constraints)) {
            return this.center;
        }
        if (NORTH.equals(constraints)) {
            return this.north;
        }
        if (SOUTH.equals(constraints)) {
            return this.south;
        }
        if (WEST.equals(constraints)) {
            return this.west;
        }
        if (EAST.equals(constraints)) {
            return this.east;
        }
        if ("First".equals(constraints)) {
            return this.firstLine;
        }
        if ("Last".equals(constraints)) {
            return this.lastLine;
        }
        if ("Before".equals(constraints)) {
            return this.firstItem;
        }
        if ("After".equals(constraints)) {
            return this.lastItem;
        }
        throw new IllegalArgumentException("cannot get component: unknown constraint: " + constraints);
    }

    public Component getLayoutComponent(Container target, Object constraints) {
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        Component result = null;
        if (NORTH.equals(constraints)) {
            result = this.firstLine != null ? this.firstLine : this.north;
        } else if (SOUTH.equals(constraints)) {
            result = this.lastLine != null ? this.lastLine : this.south;
        } else if (WEST.equals(constraints)) {
            Component component = result = ltr ? this.firstItem : this.lastItem;
            if (result == null) {
                result = this.west;
            }
        } else if (EAST.equals(constraints)) {
            Component component = result = ltr ? this.lastItem : this.firstItem;
            if (result == null) {
                result = this.east;
            }
        } else if (CENTER.equals(constraints)) {
            result = this.center;
        } else {
            throw new IllegalArgumentException("cannot get component: invalid constraint: " + constraints);
        }
        return result;
    }

    public Object getConstraints(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp == this.center) {
            return CENTER;
        }
        if (comp == this.north) {
            return NORTH;
        }
        if (comp == this.south) {
            return SOUTH;
        }
        if (comp == this.west) {
            return WEST;
        }
        if (comp == this.east) {
            return EAST;
        }
        if (comp == this.firstLine) {
            return "First";
        }
        if (comp == this.lastLine) {
            return "Last";
        }
        if (comp == this.firstItem) {
            return "Before";
        }
        if (comp == this.lastItem) {
            return "After";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d2;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c2 = null;
            c2 = this.getChild(CENTER, ltr);
            if (c2 != null) {
                d2 = c2.getMinimumSize();
                dim.width += d2.width;
                dim.height = Math.max(d2.height, dim.height);
            }
            if ((c2 = this.getChild(NORTH, ltr)) != null) {
                d2 = c2.getMinimumSize();
                dim.width = Math.max(d2.width, dim.width);
                dim.height += d2.height + this.vgap;
            }
            if ((c2 = this.getChild(SOUTH, ltr)) != null) {
                d2 = c2.getMinimumSize();
                dim.width = Math.max(d2.width, dim.width);
                dim.height += d2.height + this.vgap;
            }
            if ((c2 = this.getChild(EAST, ltr)) != null) {
                d2 = c2.getMinimumSize();
                dim.width += d2.width + this.hgap;
                dim.height = Math.max(d2.height, dim.height);
            }
            if ((c2 = this.getChild(WEST, ltr)) != null) {
                d2 = c2.getMinimumSize();
                dim.width += d2.width + this.hgap;
                dim.height = Math.max(d2.height, dim.height);
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d2;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c2 = null;
            c2 = this.getChild(CENTER, ltr);
            if (c2 != null) {
                d2 = c2.getPreferredSize();
                dim.width += d2.width;
                dim.height = Math.max(d2.height, dim.height);
            }
            if ((c2 = this.getChild(NORTH, ltr)) != null) {
                d2 = c2.getPreferredSize();
                dim.width = Math.max(d2.width, dim.width);
                dim.height += d2.height + this.vgap;
            }
            if ((c2 = this.getChild(SOUTH, ltr)) != null) {
                d2 = c2.getPreferredSize();
                dim.width = Math.max(d2.width, dim.width);
                dim.height += d2.height + this.vgap;
            }
            if ((c2 = this.getChild(EAST, ltr)) != null) {
                d2 = c2.getPreferredSize();
                dim.width += d2.width + this.hgap;
                dim.height = Math.max(d2.height, dim.height);
            }
            if ((c2 = this.getChild(WEST, ltr)) != null) {
                d2 = c2.getPreferredSize();
                dim.width += d2.width + this.hgap;
                dim.height = Math.max(d2.height, dim.height);
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d2;
            int eastGap;
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component north = this.getChild(NORTH, ltr);
            Component south = this.getChild(SOUTH, ltr);
            Component east = this.getChild(EAST, ltr);
            Component west = this.getChild(WEST, ltr);
            Component center = this.getChild(CENTER, ltr);
            int westGap = west != null ? west.getPreferredSize().width + this.hgap : 0;
            int n2 = eastGap = east != null ? east.getPreferredSize().width + this.hgap : 0;
            if (north != null) {
                d2 = north.getPreferredSize();
                north.setBounds(left + westGap, top, right - left - westGap - eastGap, d2.height);
                top += d2.height + this.vgap;
            }
            if (south != null) {
                d2 = south.getPreferredSize();
                south.setBounds(left + westGap, bottom - d2.height, right - left - westGap - eastGap, d2.height);
                bottom -= d2.height + this.vgap;
            }
            if (east != null) {
                east.setSize(east.getWidth(), bottom - top);
                d2 = east.getPreferredSize();
                east.setBounds(right - d2.width, top, d2.width, bottom - top);
                right -= d2.width + this.hgap;
            }
            if (west != null) {
                west.setSize(west.getWidth(), bottom - top);
                d2 = west.getPreferredSize();
                west.setBounds(left, top, d2.width, bottom - top);
                left += d2.width + this.hgap;
            }
            if (center != null) {
                center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    private Component getChild(String key, boolean ltr) {
        Component result = null;
        if (key == NORTH) {
            result = this.firstLine != null ? this.firstLine : this.north;
        } else if (key == SOUTH) {
            result = this.lastLine != null ? this.lastLine : this.south;
        } else if (key == WEST) {
            Component component = result = ltr ? this.firstItem : this.lastItem;
            if (result == null) {
                result = this.west;
            }
        } else if (key == EAST) {
            Component component = result = ltr ? this.lastItem : this.firstItem;
            if (result == null) {
                result = this.east;
            }
        } else if (key == CENTER) {
            result = this.center;
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

