/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class HeavyweightWrapper
extends Panel {
    private Component _component;
    private boolean _heavyweight;
    private final Dimension MIN_DIM = new Dimension(0, 0);

    public HeavyweightWrapper(Component component) {
        this(component, false);
    }

    public Dimension getMinimumSize() {
        return this.MIN_DIM;
    }

    public HeavyweightWrapper(Component component, boolean heavyweight) {
        this._component = component;
        if (this._component != null) {
            ((JComponent)this._component).putClientProperty("HeavyweightWrapper", this);
            this._component.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent e2) {
                }

                public void componentMoved(ComponentEvent e2) {
                }

                public void componentShown(ComponentEvent e2) {
                    HeavyweightWrapper.this.setVisible(true);
                }

                public void componentHidden(ComponentEvent e2) {
                    HeavyweightWrapper.this.setVisible(false);
                }
            });
        }
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this._heavyweight = heavyweight;
    }

    public boolean isHeavyweight() {
        return this._heavyweight;
    }

    public void setHeavyweight(boolean heavyweight) {
        this._heavyweight = heavyweight;
    }

    public void delegateAdd(Container parent, Object constraints) {
        JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
        if (this.isHeavyweight()) {
            if (this._component.getParent() != this) {
                this.add(this._component);
            }
            if (this.getParent() != parent) {
                parent.add((Component)this, constraints);
            }
        } else {
            parent.add(this._component, constraints);
        }
    }

    public void delegateRemove(Container parent) {
        JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
        if (this.isHeavyweight()) {
            this.remove(this._component);
            parent.remove(this);
        } else {
            parent.remove(this._component);
        }
    }

    public void delegateSetVisible(boolean visible) {
        if (this.isHeavyweight()) {
            this.setVisible(visible);
            this._component.setVisible(visible);
        } else {
            this._component.setVisible(visible);
        }
    }

    public void delegateSetBounds(Rectangle bounds) {
        if (this.isHeavyweight()) {
            this.setBounds(bounds);
            this._component.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            this._component.setBounds(bounds);
        }
    }

    public void delegateSetBounds(int x2, int y2, int width, int height) {
        if (this.isHeavyweight()) {
            this.setBounds(x2, y2, width, height);
            this._component.setBounds(0, 0, width, height);
        } else {
            this._component.setBounds(x2, y2, width, height);
        }
    }

    public void delegateSetLocation(int x2, int y2) {
        if (this.isHeavyweight()) {
            this.setLocation(x2, y2);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(x2, y2);
        }
    }

    public void delegateSetLocation(Point p2) {
        if (this.isHeavyweight()) {
            this.setLocation(p2);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(p2);
        }
    }

    public void delegateSetCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public void delegateSetNull() {
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", null);
        this._component = null;
    }

    public Container delegateGetParent() {
        if (this.isHeavyweight()) {
            return this.getParent();
        }
        return this._component.getParent();
    }

    public boolean delegateIsVisible() {
        if (this.isHeavyweight()) {
            return this.isVisible();
        }
        return this._component.isVisible();
    }

    public Rectangle delegateGetBounds() {
        if (this.isHeavyweight()) {
            return this.getBounds();
        }
        return this._component.getBounds();
    }

    public void delegateRepaint() {
        if (this.isHeavyweight()) {
            this.repaint();
            this._component.repaint();
        } else {
            this._component.repaint();
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        this._component = component;
    }
}

