/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCacheEntry;
import com.jidesoft.swing.GradientInfo;
import java.awt.image.BufferedImage;
import java.lang.ref.ReferenceQueue;

class GradientCache {
    private GradientCacheEntry[] gradients;
    private int size;
    private int threshold = 16;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();

    GradientCache() {
        this.loadFactor = 0.75f;
        this.gradients = new GradientCacheEntry[16];
    }

    BufferedImage retrieve(GradientInfo info) {
        int ln = info.length;
        GradientCacheEntry[] grads = this.getGradients();
        int index = GradientCache.bucket(ln, grads.length);
        GradientCacheEntry e2 = grads[index];
        while (e2 != null) {
            GradientInfo egi = e2.getInfo();
            try {
                if (egi != null && e2.length == ln && egi.isEquivalent(info)) {
                    return e2.gradient;
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            e2 = e2.next;
        }
        return null;
    }

    Object store(GradientInfo info, BufferedImage gradient) {
        int i2;
        GradientCacheEntry[] grads = this.getGradients();
        GradientCacheEntry e2 = grads[i2 = GradientCache.bucket(info.length, grads.length)];
        if (!this.entryNotInCache(e2, info)) {
            System.err.println("Duplicate entry found!");
        }
        grads[i2] = new GradientCacheEntry(info, gradient, this.queue, e2);
        if (++this.size >= this.threshold) {
            this.resize(grads.length << 1);
        }
        return null;
    }

    void clear() {
        GradientCacheEntry[] a2 = this.getGradients();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = null;
        }
        this.size = 0;
        this.threshold = 16;
        this.gradients = new GradientCacheEntry[16];
    }

    private boolean entryNotInCache(GradientCacheEntry e2, GradientInfo info) {
        while (e2 != null && e2.getInfo() != null) {
            if (e2.length == info.length && e2.getInfo().isEquivalent(info)) {
                return false;
            }
            e2 = e2.next;
        }
        return true;
    }

    private void resize(int newCapacity) {
        GradientCacheEntry[] oldArray = this.getGradients();
        int oldCapacity = oldArray.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        GradientCacheEntry[] newArray = new GradientCacheEntry[newCapacity];
        this.moveEntries(oldArray, newArray);
        this.gradients = newArray;
        if (this.size >= this.threshold >> 1) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.cleanOldCacheEntries();
            this.moveEntries(newArray, oldArray);
            this.gradients = oldArray;
        }
    }

    private GradientCacheEntry[] getGradients() {
        this.cleanOldCacheEntries();
        return this.gradients;
    }

    private static int bucket(int h2, int length) {
        return h2 & length - 1;
    }

    private void moveEntries(GradientCacheEntry[] src, GradientCacheEntry[] dest) {
        for (int j2 = 0; j2 < src.length; ++j2) {
            GradientCacheEntry e2 = src[j2];
            src[j2] = null;
            while (e2 != null) {
                GradientCacheEntry next = e2.next;
                Object o2 = e2.get();
                if (o2 == null) {
                    e2.next = null;
                    e2.gradient = null;
                    --this.size;
                } else {
                    int i2 = GradientCache.bucket(e2.length, dest.length);
                    e2.next = dest[i2];
                    dest[i2] = e2;
                }
                e2 = next;
            }
        }
    }

    private void cleanOldCacheEntries() {
        GradientCacheEntry e2;
        block0: while ((e2 = (GradientCacheEntry)this.queue.poll()) != null) {
            GradientCacheEntry prev;
            int i2 = GradientCache.bucket(e2.length, this.gradients.length);
            GradientCacheEntry p2 = prev = this.gradients[i2];
            while (p2 != null) {
                GradientCacheEntry next = p2.next;
                if (p2 == e2) {
                    if (prev == e2) {
                        this.gradients[i2] = next;
                    } else {
                        prev.next = next;
                    }
                    e2.next = null;
                    e2.gradient = null;
                    --this.size;
                    continue block0;
                }
                prev = p2;
                p2 = next;
            }
        }
    }
}

