/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList
extends JList {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private CheckBoxListSelectionModel _checkBoxListSelectionModel;
    protected Handler _handler;
    @Deprecated
    public static final String ALL = "(All)";
    public static final Object ALL_ENTRY = new AllEntry();

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector<?> listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(Object[] listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    public void setModel(ListModel model) {
        super.setModel(model);
        if (this.getCheckBoxListSelectionModel() != null) {
            this.getCheckBoxListSelectionModel().clearSelection();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void init() {
        this._checkBoxListSelectionModel = this.createCheckBoxListSelectionModel(this.getModel());
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        this._handler = this.createHandler();
        this._checkBoxListSelectionModel.addListSelectionListener(this._handler);
        JideSwingUtilities.insertMouseListener(this, this._handler, 0);
        JideSwingUtilities.insertMouseMotionListener(this, this._handler, 0);
        this.addKeyListener(this._handler);
        this.addPropertyChangeListener("model", this._handler);
        ListModel model = this.getModel();
        if (model != null) {
            model.addListDataListener(this._handler);
        }
    }

    @Override
    public int getLastVisibleIndex() {
        int visibleIndex = super.getLastVisibleIndex();
        if (visibleIndex < 0) {
            return this.getModel().getSize() - 1;
        }
        return visibleIndex;
    }

    protected CheckBoxListSelectionModel createCheckBoxListSelectionModel(ListModel model) {
        return new CheckBoxListSelectionModel(model);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(this.getActualCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        return super.getCellRenderer();
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled(int index) {
        return true;
    }

    public boolean isCheckBoxVisible(int index) {
        return true;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            boolean old = this._checkBoxEnabled;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, old, this._checkBoxEnabled);
            this.repaint();
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean clickInCheckBoxOnly) {
        if (clickInCheckBoxOnly != this._clickInCheckBoxOnly) {
            boolean old = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = clickInCheckBoxOnly;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this._clickInCheckBoxOnly);
        }
    }

    public CheckBoxListSelectionModel getCheckBoxListSelectionModel() {
        return this._checkBoxListSelectionModel;
    }

    public void setCheckBoxListSelectionModel(CheckBoxListSelectionModel checkBoxListSelectionModel) {
        if (this._checkBoxListSelectionModel != checkBoxListSelectionModel) {
            if (this._checkBoxListSelectionModel != null) {
                this.getModel().removeListDataListener(this._checkBoxListSelectionModel);
            }
            this._checkBoxListSelectionModel = checkBoxListSelectionModel;
            if (this._checkBoxListSelectionModel != null) {
                this._checkBoxListSelectionModel.setModel(this.getModel());
            }
        }
    }

    public int[] getCheckBoxListSelectedIndices() {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] temp = new int[1 + (iMax - iMin)];
        int n2 = 0;
        for (int i2 = iMin; i2 <= iMax; ++i2) {
            if (listSelectionModel.isAllEntryConsidered() && i2 == listSelectionModel.getAllEntryIndex() || !listSelectionModel.isSelectedIndex(i2)) continue;
            temp[n2] = i2;
            ++n2;
        }
        int[] indices = new int[n2];
        System.arraycopy(temp, 0, indices, 0, n2);
        return indices;
    }

    public void setCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void addCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void removeCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().removeSelectionInterval(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckBoxListSelectedIndices(int[] indices) {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        try {
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel.clearSelection();
            int size = this.getModel().getSize();
            for (int indice : indices) {
                if (indice < 0 || indice >= size) continue;
                listSelectionModel.addSelectionInterval(indice, indice);
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void setSelectedObjects(Object[] elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    public void setSelectedObjects(Vector<?> elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    private void setSelectedObjects(Map<Object, String> selected) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Object elementAt = this.getModel().getElementAt(i2);
            if (selected.get(elementAt) == null) continue;
            indices.add(i2);
        }
        int[] selectedIndices = new int[indices.size()];
        for (int i3 = 0; i3 < indices.size(); ++i3) {
            Integer row = (Integer)indices.get(i3);
            selectedIndices[i3] = row;
        }
        this.setCheckBoxListSelectedIndices(selectedIndices);
    }

    public Object[] getCheckBoxListSelectedValues() {
        CheckBoxListSelectionModel listSelectionModel = this.getCheckBoxListSelectionModel();
        ListModel model = this.getModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] temp = new Object[1 + (iMax - iMin)];
        int n2 = 0;
        for (int i2 = iMin; i2 <= iMax; ++i2) {
            if (listSelectionModel.isAllEntryConsidered() && i2 == listSelectionModel.getAllEntryIndex() || !listSelectionModel.isSelectedIndex(i2)) continue;
            temp[n2] = model.getElementAt(i2);
            ++n2;
        }
        Object[] indices = new Object[n2];
        System.arraycopy(temp, 0, indices, 0, n2);
        return indices;
    }

    public int getCheckBoxListSelectedIndex() {
        return this.getCheckBoxListSelectionModel().getMinSelectionIndex();
    }

    public Object getCheckBoxListSelectedValue() {
        int i2 = this.getCheckBoxListSelectionModel().getMinSelectionIndex();
        return i2 == -1 ? null : this.getModel().getElementAt(i2);
    }

    public void setCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel model = this.getModel();
            int c2 = model.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                if (!anObject.equals(model.getElementAt(i2))) continue;
                this.setCheckBoxListSelectedIndex(i2);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public void addCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        ListModel model = this.getModel();
        if (anObject != null) {
            int c2 = model.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                if (!anObject.equals(model.getElementAt(i2))) continue;
                this.addCheckBoxListSelectedIndex(i2);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        } else {
            int c3 = model.getSize();
            for (int i3 = 0; i3 < c3; ++i3) {
                if (model.getElementAt(i3) != null) continue;
                this.addCheckBoxListSelectedIndex(i3);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i3);
                }
                this.repaint();
                return;
            }
        }
    }

    public void addCheckBoxListSelectedValues(Object[] objects) {
        if (objects != null) {
            HashMap<Object, String> map = new HashMap<Object, String>();
            for (Object o2 : objects) {
                map.put(o2, "");
            }
            ListModel model = this.getModel();
            boolean changed = false;
            int c2 = model.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                if (map.get(model.getElementAt(i2)) == null) continue;
                this.addCheckBoxListSelectedIndex(i2);
                changed = true;
            }
            if (changed) {
                this.repaint();
            }
            map.clear();
        }
    }

    public void removeCheckBoxListSelectedValues(Object[] objects) {
        if (objects != null) {
            HashMap<Object, String> map = new HashMap<Object, String>();
            for (Object o2 : objects) {
                map.put(o2, "");
            }
            ListModel model = this.getModel();
            boolean changed = false;
            int c2 = model.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                if (map.get(model.getElementAt(i2)) == null) continue;
                this.removeCheckBoxListSelectedIndex(i2);
                changed = true;
            }
            if (changed) {
                this.repaint();
            }
            map.clear();
        }
    }

    public void removeCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel model = this.getModel();
            int c2 = model.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                if (!anObject.equals(model.getElementAt(i2))) continue;
                this.removeCheckBoxListSelectedIndex(i2);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        }
    }

    public void clearCheckBoxListSelection() {
        this.getCheckBoxListSelectionModel().clearSelection();
    }

    public void selectAll() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
        }
    }

    public void selectNone() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return size != null && size.width > 0 && size.height > 0 ? JideSwingUtilities.adjustPreferredScrollableViewportSize(this, size) : size;
    }

    protected static class Handler
    implements MouseListener,
    MouseMotionListener,
    KeyListener,
    ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        protected CheckBoxList _list;
        int hotspot;

        public Handler(CheckBoxList list) {
            this.hotspot = new JCheckBox().getPreferredSize().width;
            this._list = list;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() instanceof ListModel) {
                ((ListModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ListModel) {
                this._list.getCheckBoxListSelectionModel().setModel((ListModel)evt.getNewValue());
                ((ListModel)evt.getNewValue()).addListDataListener(this);
            }
        }

        protected boolean clicksInCheckBox(MouseEvent e2) {
            int index = this._list.locationToIndex(e2.getPoint());
            Rectangle bounds = this._list.getCellBounds(index, index);
            if (bounds != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return e2.getX() < bounds.x + this.hotspot;
                }
                return e2.getX() > bounds.x + bounds.width - this.hotspot;
            }
            return false;
        }

        public void mouseClicked(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
            if (e2.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            boolean clickInBox = this.clicksInCheckBox(e2);
            if (!this._list.isClickInCheckBoxOnly() || clickInBox) {
                int index = this._list.locationToIndex(e2.getPoint());
                this.toggleSelection(index);
                if (clickInBox) {
                    JList list;
                    Object source = e2.getSource();
                    if (source instanceof JList && !(list = (JList)source).hasFocus() && list.isFocusable() && list.isRequestFocusEnabled()) {
                        list.requestFocusInWindow();
                    }
                    e2.consume();
                }
            }
        }

        public void mouseDragged(MouseEvent e2) {
            if (e2.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            boolean clickInBox = this.clicksInCheckBox(e2);
            if ((!this._list.isClickInCheckBoxOnly() || clickInBox) && clickInBox) {
                e2.consume();
            }
        }

        public void mouseMoved(MouseEvent e2) {
        }

        public void mouseReleased(MouseEvent e2) {
            if (e2.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (this.clicksInCheckBox(e2)) {
                e2.consume();
            }
        }

        public void mouseEntered(MouseEvent e2) {
        }

        public void mouseExited(MouseEvent e2) {
        }

        public void keyPressed(KeyEvent e2) {
            if (e2.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (e2.getModifiers() == 0 && e2.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent e2) {
        }

        public void keyReleased(KeyEvent e2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelections() {
            int[] indices = this._list.getSelectedIndices();
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            selectionModel.removeListSelectionListener(this);
            selectionModel.setValueIsAdjusting(true);
            try {
                if (indices.length > 0) {
                    boolean selected = selectionModel.isSelectedIndex(indices[0]);
                    for (int index : indices) {
                        if (!this._list.isCheckBoxEnabled(index)) continue;
                        if (selected && selectionModel.isSelectedIndex(index)) {
                            selectionModel.removeSelectionInterval(index, index);
                            continue;
                        }
                        if (selected || selectionModel.isSelectedIndex(index)) continue;
                        selectionModel.addSelectionInterval(index, index);
                    }
                }
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        public void valueChanged(ListSelectionEvent e2) {
            this._list.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelection(int index) {
            if (!this._list.isEnabled() || !this._list.isCheckBoxEnabled(index)) {
                return;
            }
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            boolean selected = selectionModel.isSelectedIndex(index);
            selectionModel.removeListSelectionListener(this);
            try {
                if (selected) {
                    selectionModel.removeSelectionInterval(index, index);
                } else {
                    selectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int index = this._list.getSelectedIndex();
            this.toggleSelection(index);
        }

        public void intervalAdded(ListDataEvent e2) {
            int minIndex = Math.min(e2.getIndex0(), e2.getIndex1());
            int maxIndex = Math.max(e2.getIndex0(), e2.getIndex1());
            CheckBoxListSelectionModel listSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
        }

        public void intervalRemoved(ListDataEvent e2) {
            CheckBoxListSelectionModel listSelectionModel = this._list.getCheckBoxListSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(e2.getIndex0(), e2.getIndex1());
            }
        }

        public void contentsChanged(ListDataEvent e2) {
        }
    }

    private static final class AllEntry {
        public String toString() {
            return CheckBoxList.ALL;
        }
    }
}

