/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ArrowKeyNavigationSupport {
    private int[] _keyCode = new int[]{37, 39, 38, 40};
    private Class[] _componentTypes;
    public static final String CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT = "ArrowKeyNavigationSupport.previousAction";

    public ArrowKeyNavigationSupport() {
    }

    public ArrowKeyNavigationSupport(Class[] componentTypes) {
        this._componentTypes = componentTypes;
    }

    public ArrowKeyNavigationSupport(int[] keyCodes) {
        this._keyCode = keyCodes;
    }

    public ArrowKeyNavigationSupport(Class[] componentTypes, int[] keyCode) {
        this._keyCode = keyCode;
        this._componentTypes = componentTypes;
    }

    public void install(JComponent container) {
        for (int keyCode : this._keyCode) {
            KeyStroke keyStroke;
            InputMap inputMap = container.getInputMap(1);
            Object actionName = inputMap.get(keyStroke = KeyStroke.getKeyStroke(keyCode, 0));
            if (actionName != null) {
                container.putClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT, actionName);
            }
            container.registerKeyboardAction(new NavigationAction(container, keyCode), "ArrowKeyNavigation " + keyCode, keyStroke, 1);
        }
    }

    public void uninstall(JComponent container) {
        for (int keyCode : this._keyCode) {
            Object actionName = container.getClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT);
            if (actionName != null) {
                InputMap inputMap = container.getInputMap(1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, 0);
                inputMap.put(keyStroke, actionName);
                continue;
            }
            container.unregisterKeyboardAction(KeyStroke.getKeyStroke(keyCode, 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavigationAction
    implements ActionListener {
        private JComponent _parent;
        private int _keyCode;

        public NavigationAction(JComponent c2, int key) {
            this._parent = c2;
            this._keyCode = key;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            final ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
            final ArrayList<Component> components = new ArrayList<Component>();
            JideSwingUtilities.setRecursively(this._parent, new JideSwingUtilities.Handler(){

                public void postAction(Component c2) {
                }

                public void action(Component c2) {
                    if (ArrowKeyNavigationSupport.this._componentTypes != null) {
                        boolean allowed = false;
                        for (Class allowedType : ArrowKeyNavigationSupport.this._componentTypes) {
                            if (!allowedType.isAssignableFrom(c2.getClass())) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            return;
                        }
                    }
                    Rectangle bounds = c2.getBounds();
                    rects.add(SwingUtilities.convertRectangle(c2, bounds, NavigationAction.this._parent));
                    components.add(c2);
                }

                public boolean condition(Component c2) {
                    return c2.isVisible() && c2.isDisplayable() && c2.isFocusable() && c2.isEnabled();
                }
            });
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component c2 = null;
            switch (this._keyCode) {
                case 39: {
                    c2 = this.findComponentToRight(owner, rects, components);
                    break;
                }
                case 37: {
                    c2 = this.findComponentToLeft(owner, rects, components);
                    break;
                }
                case 38: {
                    c2 = this.findComponentToAbove(owner, rects, components);
                    break;
                }
                case 40: {
                    c2 = this.findComponentToBelow(owner, rects, components);
                }
            }
            if (c2 != null) {
                c2.requestFocusInWindow();
            }
        }

        private Component findComponentToRight(Component c2, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c2, c2.getBounds(), this._parent);
            for (int i2 = 0; i2 < rects.size(); ++i2) {
                int dist2;
                Rectangle dst = rects.get(i2);
                if (dst.x <= src.x + src.width || dst.y + dst.height < src.y || dst.y > src.y + src.height || (dist2 = dst.x - src.x - src.width) >= max) continue;
                max = dist2;
                found = components.get(i2);
            }
            return found;
        }

        private Component findComponentToBelow(Component c2, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c2, c2.getBounds(), this._parent);
            for (int i2 = 0; i2 < rects.size(); ++i2) {
                int dist2;
                Rectangle dst = rects.get(i2);
                if (dst.y <= src.y + src.height || dst.x + dst.width < src.x || dst.x > src.x + src.width || (dist2 = dst.y - src.y - src.height) >= max) continue;
                max = dist2;
                found = components.get(i2);
            }
            return found;
        }

        private Component findComponentToLeft(Component c2, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c2, c2.getBounds(), this._parent);
            for (int i2 = 0; i2 < rects.size(); ++i2) {
                int dist2;
                Rectangle dst = rects.get(i2);
                if (dst.x + dst.width >= src.x || dst.y + dst.height < src.y || dst.y > src.y + src.height || (dist2 = src.x - dst.x - dst.width) >= max) continue;
                max = dist2;
                found = components.get(i2);
            }
            return found;
        }

        private Component findComponentToAbove(Component c2, List<Rectangle> rects, List<Component> components) {
            int max = Integer.MAX_VALUE;
            Component found = null;
            Rectangle src = SwingUtilities.convertRectangle(c2, c2.getBounds(), this._parent);
            for (int i2 = 0; i2 < rects.size(); ++i2) {
                int dist2;
                Rectangle dst = rects.get(i2);
                if (dst.y + dst.height >= src.y || dst.x + dst.width < src.x || dst.x > src.x + src.width || (dist2 = src.y - dst.y - dst.height) >= max) continue;
                max = dist2;
                found = components.get(i2);
            }
            return found;
        }
    }
}

