/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.xerto.XertoUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class SlidingFrameBorder
implements Border,
UIResource {
    public static final int SHADOW_SIZE = 10;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Insets _insets;
    private static double LOG10 = Math.log(10.0);

    public SlidingFrameBorder(Color highlight, Color lightHighlight, Color shadow, Color darkShadow, Insets insets) {
        this._highlight = highlight;
        this._lightHighlight = lightHighlight;
        this._shadow = shadow;
        this._darkShadow = darkShadow;
        this._insets = insets;
    }

    public Insets getBorderInsets(Component c2) {
        return this._insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this._insets.top >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x2, y2 + this._insets.top - 1, width, height - this._insets.top + 1);
            g2.setColor(this._highlight);
            g2.drawLine(x2, y2 + this._insets.top - 5, x2 + width, y2 + this._insets.top - 5);
            g2.setColor(this._lightHighlight);
            g2.drawLine(x2, y2 + this._insets.top - 4, x2 + width, y2 + this._insets.top - 4);
            g2.setColor(this._highlight);
            g2.drawLine(x2, y2 + this._insets.top - 3, x2 + width, y2 + this._insets.top - 3);
            g2.drawLine(x2, y2 + this._insets.top - 2, x2 + width, y2 + this._insets.top - 2);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x2, y2, width, this._insets.top - 5), true, 40, false);
        }
        if (this._insets.left >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x2 + this._insets.left - 1, y2, width - this._insets.left, height);
            g2.setColor(this._highlight);
            g2.drawLine(x2 + this._insets.left - 5, y2, x2 + this._insets.left - 5, y2 + height);
            g2.setColor(this._lightHighlight);
            g2.drawLine(x2 + this._insets.left - 4, y2, x2 + this._insets.left - 4, y2 + height);
            g2.setColor(this._highlight);
            g2.drawLine(x2 + this._insets.left - 3, y2, x2 + this._insets.left - 3, y2 + height);
            g2.drawLine(x2 + this._insets.left - 2, y2, x2 + this._insets.left - 2, y2 + height);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x2, y2, this._insets.left - 5, height), false, 40, false);
        }
        if (this._insets.bottom >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x2, y2, width, height - this._insets.bottom);
            g2.setColor(this._highlight);
            g2.drawLine(x2, y2 + height - this._insets.bottom + 1, x2 + width, y2 + height - this._insets.bottom + 1);
            g2.drawLine(x2, y2 + height - this._insets.bottom + 2, x2 + width, y2 + height - this._insets.bottom + 2);
            g2.setColor(this._shadow);
            g2.drawLine(x2, y2 + height - this._insets.bottom + 3, x2 + width, y2 + height - this._insets.bottom + 3);
            g2.setColor(this._darkShadow);
            g2.drawLine(x2, y2 + height - this._insets.bottom + 4, x2 + width, y2 + height - this._insets.bottom + 4);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x2, y2 + height - this._insets.bottom + 4, width, this._insets.bottom - 5), true, 100, true);
        }
        if (this._insets.right >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x2, y2, width - this._insets.right, height);
            g2.setColor(this._highlight);
            g2.drawLine(x2 + width - this._insets.right + 1, y2, x2 + width - this._insets.right + 1, y2 + height);
            g2.drawLine(x2 + width - this._insets.right + 2, y2, x2 + width - this._insets.right + 2, y2 + height);
            g2.setColor(this._shadow);
            g2.drawLine(x2 + width - this._insets.right + 3, y2, x2 + width - this._insets.right + 3, y2 + height);
            g2.setColor(this._darkShadow);
            g2.drawLine(x2 + width - this._insets.right + 4, y2, x2 + width - this._insets.right + 4, y2 + height);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x2 + width - this._insets.right + 4, y2, this._insets.right - 5, height), false, 100, true);
        }
    }

    public static void paintGradient(Graphics g2, Rectangle rect, boolean isVertical, int darkness, boolean lighter) {
        if (isVertical) {
            for (int i2 = 1; i2 < rect.height; ++i2) {
                int iAlpha = (int)((1.0 - Math.log(i2) / LOG10) * (double)darkness);
                g2.setColor(new Color(0, 0, 0, iAlpha));
                if (lighter) {
                    g2.drawLine(rect.x, rect.y + i2, rect.x + rect.width, rect.y + i2);
                    continue;
                }
                g2.drawLine(rect.x, rect.y + rect.height - i2, rect.x + rect.width, rect.y + rect.height - i2);
            }
        } else {
            for (int i3 = 1; i3 < rect.width; ++i3) {
                int iAlpha = (int)((1.0 - Math.log(i3) / LOG10) * (double)darkness);
                g2.setColor(new Color(0, 0, 0, iAlpha));
                if (lighter) {
                    g2.drawLine(rect.x + i3, rect.y, rect.x + i3, rect.y + rect.height);
                    continue;
                }
                g2.drawLine(rect.x + rect.width - i3, rect.y, rect.x + rect.width - i3, rect.y + rect.height);
            }
        }
    }
}

