/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.AnimationController;
import com.jidesoft.plaf.windows.TMSchema;
import com.jidesoft.utils.ReflectionUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.ThemeReader;
import sun.security.action.GetPropertyAction;
import sun.swing.CachedPainter;

public class XPStyle {
    private static XPStyle xp;
    private static SkinPainter skinPainter;
    private static Boolean themeActive;
    private HashMap<String, Border> borderMap;
    private HashMap<String, Color> colorMap;
    private boolean flatMenus = XPStyle.getSysBoolean(TMSchema.Prop.FLATMENUS);

    public static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
        skinPainter.flush();
    }

    public static synchronized XPStyle getXP() {
        if (themeActive == null) {
            GetPropertyAction propertyAction;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(propertyAction = new GetPropertyAction("swing.noxp")) == null && ThemeReader.isThemed() && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    public static boolean isVista() {
        XPStyle xp = XPStyle.getXP();
        return xp != null && xp.isSkinDefined(null, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT);
    }

    public String getString(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return XPStyle.getTypeEnumName(c2, part, state, prop);
    }

    public TMSchema.TypeEnum getTypeEnum(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        int enumValue = ThemeReader.getEnum((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        return TMSchema.TypeEnum.getTypeEnum(prop, enumValue);
    }

    private static String getTypeEnumName(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        int enumValue = ThemeReader.getEnum((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        if (enumValue == -1) {
            return null;
        }
        return TMSchema.TypeEnum.getTypeEnum(prop, enumValue).getName();
    }

    public int getInt(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, int fallback) {
        return ThemeReader.getInt((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public Dimension getDimension(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getPosition((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public Point getPoint(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        Dimension d2 = ThemeReader.getPosition((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        if (d2 != null) {
            return new Point(d2.width, d2.height);
        }
        return null;
    }

    public Insets getMargin(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getThemeMargins((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public synchronized Color getColor(Skin skin, TMSchema.Prop prop, Color fallback) {
        String key = skin.toString() + "." + prop.name();
        TMSchema.Part part = skin.part;
        Color color = this.colorMap.get(key);
        if (color == null && (color = ThemeReader.getColor((String)part.getControlName(null), (int)part.getValue(), (int)TMSchema.State.getValue(part, skin.state), (int)prop.getValue())) != null) {
            color = new ColorUIResource(color);
            this.colorMap.put(key, color);
        }
        return color != null ? color : fallback;
    }

    Color getColor(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, Color fallback) {
        return this.getColor(new Skin(c2, part, state), prop, fallback);
    }

    public synchronized Border getBorder(Component c2, TMSchema.Part part) {
        if (part == TMSchema.Part.MENU) {
            if (this.flatMenus) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        Skin skin = new Skin(c2, part, null);
        Border border = this.borderMap.get(skin.string);
        if (border == null) {
            Insets m2;
            String bgType = XPStyle.getTypeEnumName(c2, part, null, TMSchema.Prop.BGTYPE);
            if ("borderfill".equalsIgnoreCase(bgType)) {
                int thickness = this.getInt(c2, part, null, TMSchema.Prop.BORDERSIZE, 1);
                Color color = this.getColor(skin, TMSchema.Prop.BORDERCOLOR, Color.black);
                border = new XPFillBorder(color, thickness);
                if (part == TMSchema.Part.CP_COMBOBOX) {
                    border = new XPStatefulFillBorder(color, thickness, part, TMSchema.Prop.BORDERCOLOR);
                }
            } else if ("imagefile".equalsIgnoreCase(bgType) && (m2 = this.getMargin(c2, part, null, TMSchema.Prop.SIZINGMARGINS)) != null) {
                border = this.getBoolean(c2, part, null, TMSchema.Prop.BORDERONLY) ? new XPImageBorder(c2, part) : (part == TMSchema.Part.CP_COMBOBOX ? new EmptyBorder(1, 1, 1, 1) : (part == TMSchema.Part.TP_BUTTON ? new XPEmptyBorder(new Insets(3, 3, 3, 3)) : new XPEmptyBorder(m2)));
            }
            if (border != null) {
                this.borderMap.put(skin.string, border);
            }
        }
        return border;
    }

    public boolean isSkinDefined(Component c2, TMSchema.Part part) {
        return part.getValue() == 0 || ThemeReader.isThemePartDefined((String)part.getControlName(c2), (int)part.getValue(), (int)0);
    }

    public synchronized Skin getSkin(Component c2, TMSchema.Part part) {
        assert (this.isSkinDefined(c2, part)) : "part " + (Object)((Object)part) + " is not defined";
        return new Skin(c2, part, null);
    }

    long getThemeTransitionDuration(Component c2, TMSchema.Part part, TMSchema.State stateFrom, TMSchema.State stateTo, TMSchema.Prop prop) {
        return ThemeReader.getThemeTransitionDuration((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, stateFrom), (int)TMSchema.State.getValue(part, stateTo), (int)(prop != null ? prop.getValue() : 0));
    }

    private XPStyle() {
        this.colorMap = new HashMap();
        this.borderMap = new HashMap();
    }

    private boolean getBoolean(Component c2, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getBoolean((String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    static Dimension getPartSize(TMSchema.Part part, TMSchema.State state) {
        return ThemeReader.getPartSize((String)part.getControlName(null), (int)part.getValue(), (int)TMSchema.State.getValue(part, state));
    }

    private static boolean getSysBoolean(TMSchema.Prop prop) {
        return ThemeReader.getSysBoolean((String)"window", (int)prop.getValue());
    }

    static {
        skinPainter = new SkinPainter();
        themeActive = null;
        XPStyle.invalidateStyle();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    XPStyle.invalidateStyle();
                }
            }
        });
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;

        public GlyphButton(Component parent, TMSchema.Part part) {
            XPStyle xp = XPStyle.getXP();
            this.skin = xp.getSkin(parent, part);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setMinimumSize(new Dimension(5, 5));
            this.setPreferredSize(new Dimension(16, 16));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        protected TMSchema.State getState() {
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!this.isEnabled()) {
                state = TMSchema.State.DISABLED;
            } else if (this.getModel().isPressed()) {
                state = TMSchema.State.PRESSED;
            } else if (this.getModel().isRollover()) {
                state = TMSchema.State.HOT;
            }
            return state;
        }

        public void paintComponent(Graphics g2) {
            Dimension d2 = this.getSize();
            this.skin.paintSkin(g2, 0, 0, d2.width, d2.height, this.getState());
        }

        public void setPart(Component parent, TMSchema.Part part) {
            XPStyle xp = XPStyle.getXP();
            this.skin = xp.getSkin(parent, part);
            this.revalidate();
            this.repaint();
        }

        protected void paintBorder(Graphics g2) {
        }
    }

    private static class SkinPainter
    extends CachedPainter {
        SkinPainter() {
            super(30);
            this.flush();
        }

        public void flush() {
            super.flush();
        }

        protected void paintToImage(Component c2, Image image2, Graphics g2, int w2, int h2, Object[] args) {
            if (!SystemInfo.isJdk7Above()) {
                BufferedImage bi2;
                SurfaceManager sm;
                boolean accEnabled = false;
                Skin skin = (Skin)args[0];
                TMSchema.Part part = skin.part;
                TMSchema.State state = (TMSchema.State)((Object)args[1]);
                if (state == null) {
                    state = skin.state;
                }
                if (c2 == null) {
                    c2 = skin.component;
                }
                if ((sm = SurfaceManager.getManager(bi2 = (BufferedImage)image2)).getClass().getName().equals("sun.awt.image.CachingSurfaceManager")) {
                    try {
                        accEnabled = (Boolean)ReflectionUtils.callGet(sm, "isLocalAccelerationEnabled");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                WritableRaster raster = bi2.getRaster();
                DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
                ThemeReader.paintBackground((int[])buffer.getData(), (String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)0, (int)0, (int)w2, (int)h2, (int)w2);
                if (sm.getClass().getName().equals("sun.awt.image.CachingSurfaceManager")) {
                    try {
                        boolean oldAccEnabled = (Boolean)ReflectionUtils.callGet(sm, "isLocalAccelerationEnabled");
                        if (accEnabled != oldAccEnabled) {
                            ReflectionUtils.callSet(sm, "setLocalAccelerationEnabled", accEnabled);
                            ReflectionUtils.call(sm, "rasterChanged");
                        }
                    }
                    catch (Exception e3) {}
                }
            } else {
                boolean accEnabled = false;
                Skin skin = (Skin)args[0];
                TMSchema.Part part = skin.part;
                TMSchema.State state = (TMSchema.State)((Object)args[1]);
                if (state == null) {
                    state = skin.state;
                }
                if (c2 == null) {
                    c2 = skin.component;
                }
                BufferedImage bi3 = (BufferedImage)image2;
                WritableRaster raster = bi3.getRaster();
                DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
                try {
                    ThemeReader.paintBackground((int[])((int[])ReflectionUtils.callStatic(SunWritableRaster.class, "stealData", new Class[]{DataBufferInt.class, Integer.TYPE}, new Object[]{dbi, 0})), (String)part.getControlName(c2), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)0, (int)0, (int)w2, (int)h2, (int)w2);
                    ReflectionUtils.callStatic(SunWritableRaster.class, "markDirty", new Class[]{DataBuffer.class}, new Object[]{dbi});
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }

        protected Image createImage(Component c2, int w2, int h2, GraphicsConfiguration config2, Object[] args) {
            return new BufferedImage(w2, h2, 2);
        }
    }

    public static class Skin {
        final Component component;
        final TMSchema.Part part;
        final TMSchema.State state;
        private final String string;
        private Dimension size = null;

        Skin(Component component, TMSchema.Part part) {
            this(component, part, null);
        }

        Skin(TMSchema.Part part, TMSchema.State state) {
            this(null, part, state);
        }

        Skin(Component component, TMSchema.Part part, TMSchema.State state) {
            this.component = component;
            this.part = part;
            this.state = state;
            String str = part.getControlName(component) + "." + part.name();
            if (state != null) {
                str = str + "(" + state.name() + ")";
            }
            this.string = str;
        }

        private int getWidth(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.width;
        }

        int getWidth() {
            return this.getWidth(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        private int getHeight(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.height;
        }

        int getHeight() {
            return this.getHeight(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object obj) {
            return obj instanceof Skin && ((Skin)obj).string.equals(this.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public void paintSkin(Graphics g2, int dx, int dy, TMSchema.State state) {
            if (state == null) {
                state = this.state;
            }
            this.paintSkin(g2, dx, dy, this.getWidth(state), this.getHeight(state), state);
        }

        public void paintSkin(Graphics g2, Rectangle r2, TMSchema.State state) {
            this.paintSkin(g2, r2.x, r2.y, r2.width, r2.height, state);
        }

        public void paintSkin(Graphics g2, int dx, int dy, int dw, int dh2, TMSchema.State state) {
            if (SystemInfo.isJdk6Above() && ThemeReader.isGetThemeTransitionDurationDefined() && this.component instanceof JComponent && SwingUtilities.getAncestorOfClass(CellRendererPane.class, this.component) == null) {
                AnimationController.paintSkin((JComponent)this.component, this, g2, dx, dy, dw, dh2, state);
            } else {
                this.paintSkinRaw(g2, dx, dy, dw, dh2, state);
            }
        }

        public void paintSkinRaw(Graphics g2, int dx, int dy, int dw, int dh2, TMSchema.State state) {
            skinPainter.paint(null, g2, dx, dy, dw, dh2, new Object[]{this, state});
        }

        public void paintSkin(Graphics g2, int dx, int dy, int dw, int dh2, TMSchema.State state, boolean borderFill) {
            if (borderFill && "borderfill".equals(XPStyle.getTypeEnumName(this.component, this.part, state, TMSchema.Prop.BGTYPE))) {
                return;
            }
            skinPainter.paint(null, g2, dx, dy, dw, dh2, new Object[]{this, state});
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets m2) {
            super(m2.top + 2, m2.left + 2, m2.bottom + 2, m2.right + 2);
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            insets = super.getBorderInsets(c2, insets);
            Insets margin = null;
            if (c2 instanceof AbstractButton) {
                Insets m2 = ((AbstractButton)c2).getMargin();
                if (c2.getParent() instanceof JToolBar && !(c2 instanceof JRadioButton) && !(c2 instanceof JCheckBox) && m2 instanceof InsetsUIResource) {
                    insets.top -= 2;
                    insets.left -= 2;
                    insets.bottom -= 2;
                    insets.right -= 2;
                } else {
                    margin = m2;
                }
            } else if (c2 instanceof JToolBar) {
                margin = ((JToolBar)c2).getMargin();
            } else if (c2 instanceof JTextComponent) {
                margin = ((JTextComponent)c2).getMargin();
            }
            if (margin != null) {
                insets.top = margin.top + 2;
                insets.left = margin.left + 2;
                insets.bottom = margin.bottom + 2;
                insets.right = margin.right + 2;
            }
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(Component c2, TMSchema.Part part) {
            this.skin = XPStyle.this.getSkin(c2, part);
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            this.skin.paintSkin(g2, x2, y2, width, height, null);
        }
    }

    private class XPStatefulFillBorder
    extends XPFillBorder {
        private final TMSchema.Part part;
        private final TMSchema.Prop prop;

        XPStatefulFillBorder(Color color, int thickness, TMSchema.Part part, TMSchema.Prop prop) {
            super(color, thickness);
            this.part = part;
            this.prop = prop;
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            JComboBox cb2;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (c2 instanceof JComboBox && (cb2 = (JComboBox)c2).getUI() instanceof WindowsComboBoxUI) {
                WindowsComboBoxUI wcb = (WindowsComboBoxUI)cb2.getUI();
            }
            this.lineColor = XPStyle.this.getColor(c2, this.part, state, this.prop, Color.black);
            super.paintBorder(c2, g2, x2, y2, width, height);
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int thickness) {
            super(color, thickness);
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            Insets margin = null;
            if (c2 instanceof AbstractButton) {
                margin = ((AbstractButton)c2).getMargin();
            } else if (c2 instanceof JToolBar) {
                margin = ((JToolBar)c2).getMargin();
            } else if (c2 instanceof JTextComponent) {
                margin = ((JTextComponent)c2).getMargin();
            }
            insets.top = (margin != null ? margin.top : 0) + this.thickness;
            insets.left = (margin != null ? margin.left : 0) + this.thickness;
            insets.bottom = (margin != null ? margin.bottom : 0) + this.thickness;
            insets.right = (margin != null ? margin.right : 0) + this.thickness;
            return insets;
        }
    }
}

