/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.eclipse.EclipseMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class EclipseJideSplitButtonUI
extends EclipseMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent c2) {
        return new EclipseJideSplitButtonUI();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent e2) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent e2) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c2) {
        EclipseJideSplitButtonUI ui;
        if (condition == 0 && (ui = (EclipseJideSplitButtonUI)EclipseJideSplitButtonUI.getUIOfType(((JideSplitButton)c2).getUI(), EclipseJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem b2 = this.menuItem;
        LazyActionMap.installLazyActionMap(b2, EclipseJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap km = this.getInputMap(0, b2);
        SwingUtilities.replaceUIInputMap(b2, 0, km);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem b2 = this.menuItem;
        SwingUtilities.replaceUIInputMap(b2, 2, null);
        SwingUtilities.replaceUIInputMap(b2, 0, null);
        SwingUtilities.replaceUIActionMap(b2, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent c2) {
        return new MouseInputHandler();
    }

    protected Rectangle getButtonRect(JComponent c2, int orientation, int width, int height) {
        Rectangle rect = orientation == 0 && c2.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin, height);
        return rect;
    }

    protected Rectangle getDropDownRect(JComponent c2, int orientation, int width, int height) {
        Object position = c2.getClientProperty("JButton.segmentPosition");
        Rectangle rect = c2.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), height) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), height);
        if (position != null && !"only".equals(position)) {
            if ("first".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("middle".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("last".equals(position)) {
                // empty if block
            }
        }
        return rect;
    }

    protected void paintSunkenBorder(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintSunken2Border(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._darkShadowColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 2, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 2);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x + 1, b2.y + 1, b2.x + b2.width - 3, b2.y + 1);
        g2.drawLine(b2.x + 1, b2.y + 1, b2.x + 1, b2.y + b2.height - 3);
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.x, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintRaisedBorder(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintRaised2Border(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x + 1, b2.y + b2.height - 2, b2.x + b2.width - 2, b2.y + b2.height - 2);
        g2.drawLine(b2.x + b2.width - 2, 1, b2.x + b2.width - 2, b2.y + b2.height - 2);
        g2.setColor(this._darkShadowColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    private Color getForegroundOfState(JMenuItem menuItem) {
        int state = JideSwingUtilities.getButtonState(menuItem);
        Color foreground = null;
        if (menuItem instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)menuItem)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = menuItem.getForeground();
        }
        return foreground;
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        JideSplitButton b2;
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        orientation = 0;
        Object o2 = menuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean paintBackground = o2 instanceof Boolean ? ((Boolean)o2).booleanValue() : menuItem.isOpaque();
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g2, menuItem, bgColor);
            if (menuItem.isEnabled()) {
                if (model.isArmed() || model.isPressed() || this.isMouseOver()) {
                    g2.setColor(this.selectionForeground);
                    g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g2, this.selectionForeground, menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                } else {
                    g2.setColor(this.getForegroundOfState(menuItem));
                    g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g2, this.getForegroundOfState(menuItem), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                }
            } else {
                g2.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("controlDkShadow"), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
            }
            return;
        }
        if (paintBackground) {
            if (menuItem.getParent() != null) {
                g2.setColor(menuItem.getParent().getBackground());
            } else {
                g2.setColor(menuItem.getBackground());
            }
            g2.fillRect(0, 0, menuWidth, menuHeight);
        }
        if ((b2 = (JideSplitButton)menuItem).getButtonStyle() == 0) {
            if (model.isSelected()) {
                if (b2.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                } else if (b2.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 5);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
                }
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 4);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 4);
                    }
                } else {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 5);
                    }
                }
            } else if ((b2.isRolloverEnabled() && this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                if (b2.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                }
            } else if (paintBackground) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isEnabled() && b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g2, rect, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g2, rect, 0);
                }
            }
        } else if (b2.getButtonStyle() == 2) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                if (!b2.isOpaque()) {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintSunkenBorder(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    }
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b2.isOpaque()) {
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    }
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g2, rect);
                    }
                }
            } else if ((b2.isRolloverEnabled() && this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                if (b2.isAlwaysDropdown()) {
                    rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                } else {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (b2.isOpaque()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
            }
        } else if (b2.getButtonStyle() == 1) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                if (!b2.isOpaque()) {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintSunken2Border(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if (this.isMouseOver() && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                    }
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b2.isOpaque()) {
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                    }
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                }
            } else if (b2.isRolloverEnabled() && this.isMouseOver() && model.isEnabled()) {
                if (b2.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    this.paintRaised2Border(g2, rect);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g2, rect);
                }
            } else if (b2.isOpaque()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
            } else if (b2.isAlwaysDropdown()) {
                Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
            } else {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
            }
        }
        this.paintArrow(menuItem, g2);
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g2) {
        int menuHeight;
        int menuWidth;
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        int startX = menuItem.getComponentOrientation().isLeftToRight() ? menuWidth - 9 : 4;
        if (menuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(g2, this.getForegroundOfState(menuItem), startX, menuHeight / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("controlShadow"), startX, menuHeight / 2 - 1, 5, 0);
        }
    }

    public Dimension getMinimumSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getMinimumSize(c2);
        }
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            if (JideSwingUtilities.getOrientationOf(c2) == 0) {
                d2.width = (int)((float)d2.width - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            } else {
                d2.height = (int)((float)d2.height - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            }
        }
        return d2;
    }

    public Dimension getMaximumSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getMaximumSize(c2);
        }
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            if (JideSwingUtilities.getOrientationOf(c2) == 0) {
                d2.width = (int)((float)d2.width + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
            } else {
                d2.height = (int)((float)d2.height + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
            }
        }
        return d2;
    }

    public Dimension getPreferredSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getPreferredSize(c2);
        }
        AbstractButton b2 = (AbstractButton)c2;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c2) == 1) {
            isHorizontal = false;
        }
        Dimension d2 = BasicGraphicsUtils.getPreferredButtonSize(b2, this.defaultTextIconGap);
        int size = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        d2.width += size;
        if (isHorizontal) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    protected void paintIcon(JMenuItem b2, Graphics g2) {
        ButtonModel model = b2.getModel();
        if (b2.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(b2) == 1) {
                g2.translate(0, b2.getWidth() - 1);
                ((Graphics2D)g2).rotate(-1.5707963267948966);
            }
            if (!model.isEnabled()) {
                icon = b2.getDisabledIcon();
                if (icon == null) {
                    icon = b2.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b2, icon);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b2.getPressedIcon();
                if (icon == null) {
                    icon = b2.getIcon();
                }
            } else {
                icon = b2.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(b2, g2, EclipseJideSplitButtonUI.iconRect.x, EclipseJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(b2) == 1) {
                ((Graphics2D)g2).rotate(1.5707963267948966);
                g2.translate(0, -b2.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 1;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("downPressed"));
        map.put(new Actions("downReleased"));
    }

    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int mnemonic = this.menuItem.getModel().getMnemonic();
        if (mnemonic != 0 && this.windowInputMap != null) {
            int[] shortcutKeys = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (shortcutKeys == null) {
                shortcutKeys = new int[]{8};
            }
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu menu) {
        MenuElement[] selectedPath;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        if (menu.isTopLevelMenu()) {
            if (menu.isSelected()) {
                manager.clearSelectedPath();
            } else {
                Container cnt = EclipseJideSplitButtonUI.getFirstParentMenuElement(menu);
                if (cnt != null && cnt instanceof MenuElement) {
                    ArrayList<Container> parents = new ArrayList<Container>();
                    while (cnt instanceof MenuElement) {
                        parents.add(0, cnt);
                        if (cnt instanceof JPopupMenu) {
                            cnt = (Container)((JPopupMenu)cnt).getInvoker();
                            continue;
                        }
                        cnt = EclipseJideSplitButtonUI.getFirstParentMenuElement(cnt);
                    }
                    MenuElement[] me = new MenuElement[parents.size() + 1];
                    for (int i2 = 0; i2 < parents.size(); ++i2) {
                        Container container = (Container)parents.get(i2);
                        me[i2] = (MenuElement)((Object)container);
                    }
                    me[parents.size()] = menu;
                    manager.setSelectedPath(me);
                } else {
                    MenuElement[] me = new MenuElement[]{menu};
                    manager.setSelectedPath(me);
                }
            }
        }
        if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
            if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                EclipseJideSplitButtonUI.appendPath(selectedPath, menu.getPopupMenu());
            } else {
                EclipseJideSplitButtonUI.setupPostTimer(menu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MenuElement)) continue;
            return parent;
        }
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            String key = this.getName();
            if (PRESS.equals(key) && ((JideSplitButton)b2).isAlwaysDropdown()) {
                key = DOWN_PRESS;
            }
            if (PRESS.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b2.hasFocus()) {
                    b2.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else if (DOWN_PRESS.equals(key)) {
                EclipseJideSplitButtonUI.downButtonPressed((JMenu)b2);
            } else if (DOWN_RELEASE.equals(key)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e2) {
            this.cancelMenuIfNecessary(e2);
        }

        public void mousePressed(MouseEvent e2) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            EclipseJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                return;
            }
            if (this.isClickOnButton(e2, menu)) {
                if (((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    menu.getModel().setArmed(true);
                    menu.getModel().setPressed(true);
                }
                if (!menu.hasFocus() && menu.isRequestFocusEnabled()) {
                    menu.requestFocus();
                }
            } else {
                EclipseJideSplitButtonUI.downButtonPressed(menu);
            }
        }

        private boolean isClickOnButton(MouseEvent e2, JMenu menu) {
            int size;
            if (((JideSplitButton)menu).isAlwaysDropdown()) {
                return false;
            }
            boolean clickOnDropDown = false;
            int n2 = size = ((JMenu)EclipseJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? EclipseJideSplitButtonUI.this._splitButtonMargin : EclipseJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(EclipseJideSplitButtonUI.this.menuItem) == 0) {
                if (e2.getPoint().getX() < (double)(menu.getWidth() - size)) {
                    clickOnDropDown = true;
                }
            } else if (e2.getPoint().getY() < (double)(menu.getHeight() - size)) {
                clickOnDropDown = true;
            }
            return clickOnDropDown;
        }

        public void mouseReleased(MouseEvent e2) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(e2, menu)) {
                EclipseJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                EclipseJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(e2);
        }

        private void cancelMenuIfNecessary(MouseEvent e2) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(e2, menu) && ((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(e2)) {
                    menu.getModel().setPressed(false);
                    menu.getModel().setArmed(false);
                } else {
                    menu.getModel().setArmed(false);
                    menu.getModel().setPressed(false);
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElements = manager.getSelectedPath();
                for (int i2 = menuElements.length - 1; i2 >= 0; --i2) {
                    MenuElement menuElement = menuElements[i2];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(menu)) continue;
                    menu.getModel().setRollover(false);
                    EclipseJideSplitButtonUI.this.setMouseOver(false);
                    manager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent e2) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        EclipseMenuUI.appendPath(EclipseJideSplitButtonUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(EclipseJideSplitButtonUI.this.getPath());
                        EclipseMenuUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                EclipseJideSplitButtonUI.this.setMouseOver(true);
            }
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent e2) {
            EclipseJideSplitButtonUI.this.setMouseOver(false);
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent e2) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e2);
        }

        public void mouseMoved(MouseEvent e2) {
        }
    }
}

