/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI {
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected static final int MOUSE_HANDLE_BOTH = 7;
    protected boolean hover;
    protected boolean second;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public BasicRangeSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent slider) {
        return new BasicRangeSliderUI((JSlider)slider);
    }

    public void paint(Graphics g2, JComponent c2) {
        this.second = false;
        super.paint(g2, c2);
        Rectangle clip = g2.getClipBounds();
        this.second = true;
        Point p2 = this.adjustThumbForHighValue();
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g2);
        }
        this.restoreThumbForLowValue(p2);
        this.second = false;
    }

    protected void restoreThumbForLowValue(Point p2) {
        this.thumbRect.x = p2.x;
        this.thumbRect.y = p2.y;
    }

    protected Point adjustThumbForHighValue() {
        Point p2 = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
        return p2;
    }

    protected void adjustSnapHighValue() {
        int sliderValue;
        int snappedValue = sliderValue = ((RangeSlider)this.slider).getHighValue();
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int tickSpacing = 0;
        if (minorTickSpacing > 0) {
            tickSpacing = minorTickSpacing;
        } else if (majorTickSpacing > 0) {
            tickSpacing = majorTickSpacing;
        }
        if (tickSpacing != 0) {
            if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                int whichTick = Math.round(temp);
                snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
            }
            if (snappedValue != sliderValue) {
                ((RangeSlider)this.slider).setHighValue(snappedValue);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapHighValue();
        }
        super.calculateThumbLocation();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener(super.createTrackListener(slider));
    }

    protected int getMouseHandle(int x2, int y2) {
        int maxX;
        Rectangle rect = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        boolean inMin = false;
        boolean inMax = false;
        if (this.thumbRect.contains(x2, y2)) {
            inMin = true;
        }
        Point p2 = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(x2, y2)) {
            inMax = true;
        }
        this.restoreThumbForLowValue(p2);
        if (inMin && inMax) {
            return 7;
        }
        if (inMin) {
            return 1;
        }
        if (inMax) {
            return 2;
        }
        if (this.slider.getOrientation() == 1) {
            int maxY;
            int minY = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle midRect = new Rectangle(rect.x, Math.min(minY, maxY = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rect.width, Math.abs(maxY - minY) - this.thumbRect.height);
            if (midRect.contains(x2, y2)) {
                return 4;
            }
            int sy = rect.y + Math.max(minY, maxY) + this.thumbRect.height / 2;
            Rectangle lowerRect = new Rectangle(rect.x, sy, rect.width, rect.y + rect.height - sy);
            if (lowerRect.contains(x2, y2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle upperRect = new Rectangle(rect.x, rect.y, rect.width, Math.min(maxY, minY) - this.thumbRect.height / 2);
            if (upperRect.contains(x2, y2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int minX = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle midRect = new Rectangle(Math.min(minX, maxX = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rect.y, Math.abs(maxX - minX) - this.thumbRect.width, rect.height);
        if (midRect.contains(x2, y2)) {
            return 4;
        }
        Rectangle lowerRect = new Rectangle(rect.x, rect.y, Math.min(minX, maxX) - this.thumbRect.width / 2 - rect.x, rect.height);
        if (lowerRect.contains(x2, y2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int sx = rect.x + Math.abs(maxX - minX) + this.thumbRect.width / 2;
        Rectangle upperRect = new Rectangle(sx, rect.y, rect.width - sx, rect.height);
        if (upperRect.contains(x2, y2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics g2) {
        try {
            Field field = this.getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set(this, this.second ? this.rollover2 : this.rollover1);
            field = this.getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set(this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException e2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(g2);
    }

    protected void setMouseRollover(int handle) {
        switch (handle) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p2 = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p2);
    }

    protected void setMousePressed(int handle) {
        switch (handle) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p2 = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p2);
    }

    protected void setMouseReleased(int handle) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point p2 = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByBlock");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int delta = 1 * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByUnit");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener listener) {
            super(BasicRangeSliderUI.this);
            this._listener = listener;
        }

        public void mousePressed(MouseEvent e2) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (BasicRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                BasicRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = BasicRangeSliderUI.this.getMouseHandle(e2.getX(), e2.getY());
            BasicRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4 || this.handle == 7) {
                this.handleOffset = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e2.getY() - BasicRangeSliderUI.this.yPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue()) : e2.getX() - BasicRangeSliderUI.this.xPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e2.getY() : e2.getX();
                BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(e2);
                BasicRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        public void mouseDragged(MouseEvent e2) {
            int newValue;
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int newLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e2.getY() : e2.getX();
            int n2 = newValue = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(newLocation) : BasicRangeSliderUI.this.valueForXPosition(newLocation);
            if (newValue < BasicRangeSliderUI.this.slider.getModel().getMinimum()) {
                newValue = BasicRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (newValue > BasicRangeSliderUI.this.slider.getModel().getMaximum()) {
                newValue = BasicRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 7) {
                if (newLocation - this.mouseStartLocation >= 1) {
                    this.handle = 2;
                } else if (newLocation - this.mouseStartLocation <= -1) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)BasicRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(newValue, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), newValue));
                    break;
                }
                case 4: {
                    int delta;
                    if (!((RangeSlider)BasicRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n3 = delta = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue() : BasicRangeSliderUI.this.valueForXPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue();
                    if (delta < 0 && rangeSlider.getLowValue() + delta < rangeSlider.getMinimum()) {
                        delta = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (delta > 0 && rangeSlider.getHighValue() + delta > rangeSlider.getMaximum()) {
                        delta = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (delta == 0) break;
                    rangeSlider.setLowValue(rangeSlider.getLowValue() + delta);
                    rangeSlider.setHighValue(rangeSlider.getHighValue() + delta);
                }
            }
        }

        public void mouseReleased(MouseEvent e2) {
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            BasicRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(e2);
        }

        private void setCursor(int c2) {
            Cursor cursor = Cursor.getPredefinedCursor(c2);
            if (BasicRangeSliderUI.this.slider.getCursor() != cursor) {
                BasicRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        public void mouseMoved(MouseEvent e2) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int handle = BasicRangeSliderUI.this.getMouseHandle(e2.getX(), e2.getY());
            BasicRangeSliderUI.this.setMouseRollover(handle);
            switch (handle) {
                case 1: {
                    this.setCursor(0);
                    break;
                }
                case 2: {
                    this.setCursor(0);
                    break;
                }
                case 4: 
                case 7: {
                    if (BasicRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)BasicRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                BasicRangeSliderUI.this.slider.getModel().setValue(BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.getModel().setExtent(BasicRangeSliderUI.this.slider.getModel().getMaximum() - BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.repaint();
            }
        }

        public void mouseEntered(MouseEvent e2) {
            BasicRangeSliderUI.this.hover = true;
            BasicRangeSliderUI.this.slider.repaint();
        }

        public void mouseExited(MouseEvent e2) {
            BasicRangeSliderUI.this.hover = false;
            BasicRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

