/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;

public class BasicJideButtonListener
extends BasicButtonListener {
    private boolean _mouseOver = false;

    public BasicJideButtonListener(AbstractButton b2) {
        super(b2);
    }

    public void mouseEntered(MouseEvent e2) {
        AbstractButton b2 = (AbstractButton)e2.getSource();
        ButtonModel model = b2.getModel();
        if (b2.isRolloverEnabled()) {
            model.setRollover(true);
        }
        this._mouseOver = true;
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent e2) {
        super.propertyChange(e2);
        String prop = e2.getPropertyName();
        if ("buttonStyle".equals(prop) || "opaque".equals(prop) || "contentAreaFilled".equals(prop)) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            b2.repaint();
        } else if ("orientation".equals(prop) || "hideActionText".equals(prop)) {
            AbstractButton b3 = (AbstractButton)e2.getSource();
            b3.invalidate();
            b3.repaint();
        } else if ("verticalTextPosition".equals(prop) || "horizontalTextPosition".equals(prop)) {
            AbstractButton b4 = (AbstractButton)e2.getSource();
            b4.updateUI();
        }
    }

    public void mouseClicked(MouseEvent e2) {
        super.mouseClicked(e2);
        this.cancelMenuIfNecessary(e2);
    }

    public void mouseReleased(MouseEvent e2) {
        AbstractButton b2 = (AbstractButton)e2.getSource();
        ButtonModel model = b2.getModel();
        if (b2.contains(e2.getPoint()) && b2.isRolloverEnabled()) {
            model.setRollover(true);
        }
        if (!this._mouseOver) {
            model.setArmed(false);
            model.setPressed(false);
        }
        super.mouseReleased(e2);
        this.cancelMenuIfNecessary(e2);
    }

    private void cancelMenuIfNecessary(MouseEvent e2) {
        AbstractButton b2 = (AbstractButton)e2.getSource();
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElements = manager.getSelectedPath();
        for (int i2 = menuElements.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElements[i2];
            if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(b2)) continue;
            b2.getModel().setPressed(false);
            b2.getModel().setArmed(false);
            b2.getModel().setRollover(false);
            if (Boolean.FALSE.equals(b2.getClientProperty("JideButton.hidePopupMenu"))) break;
            manager.clearSelectedPath();
            break;
        }
    }

    public void mouseExited(MouseEvent e2) {
        AbstractButton b2 = (AbstractButton)e2.getSource();
        ButtonModel model = b2.getModel();
        if (b2.isRolloverEnabled()) {
            model.setRollover(false);
        }
        model.setArmed(false);
        this._mouseOver = false;
    }

    void updateMnemonicBinding(AbstractButton b2) {
        int m2 = b2.getMnemonic();
        if (m2 != 0) {
            InputMap map = SwingUtilities.getUIInputMap(b2, 2);
            if (map == null) {
                map = new ComponentInputMapUIResource(b2);
                SwingUtilities.replaceUIInputMap(b2, 2, map);
            }
            map.clear();
            map.put(KeyStroke.getKeyStroke(m2, JideSwingUtilities.getFocusAcceleratorKeyMask(), false), "pressed");
            map.put(KeyStroke.getKeyStroke(m2, JideSwingUtilities.getFocusAcceleratorKeyMask(), true), "released");
            map.put(KeyStroke.getKeyStroke(m2, 0, true), "released");
        } else {
            InputMap map = SwingUtilities.getUIInputMap(b2, 2);
            if (map != null) {
                map.clear();
            }
        }
    }

    static Object getUIOfType(ComponentUI ui, Class clazz) {
        if (clazz.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c2) {
        BasicJideButtonUI ui;
        if (condition == 0 && (ui = (BasicJideButtonUI)BasicJideButtonListener.getUIOfType(((AbstractButton)c2).getUI(), BasicJideButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
    }

    public void installKeyboardActions(JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        this.updateMnemonicBinding(b2);
        LazyActionMap.installLazyActionMap(c2, BasicJideButtonListener.class, "JideButton.actionMap");
        InputMap km = this.getInputMap(0, c2);
        SwingUtilities.replaceUIInputMap(c2, 0, km);
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            String key = this.getName();
            if (PRESS.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b2.hasFocus() && b2.isRequestFocusEnabled()) {
                    b2.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }
}

