/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicGripperUI
extends GripperUI {
    private int _size;
    protected ThemePainter _painter;
    protected Painter _gripperPainter;

    public static ComponentUI createUI(JComponent c2) {
        return new BasicGripperUI();
    }

    public void installUI(JComponent c2) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("Gripper.painter");
        this.installDefaults((Gripper)c2);
        this.installListeners((Gripper)c2);
    }

    public void uninstallUI(JComponent c2) {
        this._painter = null;
        this._gripperPainter = null;
        this.uninstallDefaults((Gripper)c2);
        this.uninstallListeners((Gripper)c2);
    }

    protected void installDefaults(Gripper s2) {
        this._size = UIDefaultsLookup.getInt("Gripper.size");
    }

    protected void uninstallDefaults(Gripper s2) {
    }

    protected MouseListener createMouseListener() {
        return new GripperMouseListener();
    }

    protected void installListeners(Gripper g2) {
        MouseListener listener = this.createMouseListener();
        if (listener != null) {
            g2.putClientProperty(this, listener);
            g2.addMouseListener(listener);
        }
    }

    protected void uninstallListeners(Gripper g2) {
        MouseListener listener = (MouseListener)g2.getClientProperty(this);
        g2.putClientProperty(this, null);
        if (listener != null) {
            g2.removeMouseListener(listener);
        }
    }

    protected void paintBackground(Graphics g2, Gripper b2) {
        Rectangle rect = new Rectangle(0, 0, b2.getWidth(), b2.getHeight());
        if (b2.isRollover()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, 0, 2);
        } else if (b2.isOpaque()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, 0, b2.isSelected() ? 3 : 0, false);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(g2, rect, 0);
            }
        }
    }

    public void paint(Graphics g2, JComponent c2) {
        int state;
        Gripper gripper = (Gripper)c2;
        this.paintBackground(g2, gripper);
        int n2 = state = gripper.isSelected() ? 3 : 0;
        if (this._gripperPainter == null) {
            this.getPainter().paintGripper(c2, g2, new Rectangle(0, 0, c2.getWidth(), c2.getHeight()), gripper.getOrientation(), state);
        } else {
            this._gripperPainter.paint(c2, g2, new Rectangle(0, 0, c2.getWidth(), c2.getHeight()), gripper.getOrientation(), state);
        }
    }

    public Dimension getPreferredSize(JComponent c2) {
        return new Dimension(this._size, this._size);
    }

    public Dimension getMinimumSize(JComponent c2) {
        return this.getPreferredSize(c2);
    }

    public Dimension getMaximumSize(JComponent c2) {
        Gripper gripper = (Gripper)c2;
        if (gripper.getOrientation() == 0) {
            return new Dimension(this._size, c2.getParent().getHeight());
        }
        return new Dimension(c2.getParent().getWidth(), this._size);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    class GripperMouseListener
    extends MouseAdapter {
        GripperMouseListener() {
        }

        public void mouseEntered(MouseEvent e2) {
            super.mouseEntered(e2);
            if (e2.getSource() instanceof Gripper && ((Gripper)e2.getSource()).isRolloverEnabled()) {
                ((Gripper)e2.getSource()).setRollover(true);
            }
        }

        public void mouseExited(MouseEvent e2) {
            super.mouseExited(e2);
            if (e2.getSource() instanceof Gripper && ((Gripper)e2.getSource()).isRolloverEnabled()) {
                ((Gripper)e2.getSource()).setRollover(false);
            }
        }
    }
}

