/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UIDefaultsLookup {
    private static Logger LOGGER = Logger.getLogger(UIDefaultsLookup.class.getName());
    private static boolean _debug = false;
    private static boolean _trace = false;

    public static void setDebug(boolean debug2) {
        _debug = debug2;
    }

    public static void setTrace(boolean trace2) {
        _trace = trace2;
    }

    public static void put(UIDefaults table, String key, Object value) {
        Object cl2;
        HashMap v2 = table.get(key);
        if (v2 == null || !(v2 instanceof Map)) {
            v2 = new HashMap();
            table.put(key, v2);
        }
        if (!((cl2 = UIManager.get("ClassLoader")) instanceof ClassLoader)) {
            cl2 = value.getClass().getClassLoader();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Put " + key + " " + value + " using ClassLoader: " + cl2);
        }
        ((Map)v2).put(cl2, value);
    }

    static ClassLoader getCallerClassLoader() {
        Object cl2 = UIManager.get("ClassLoader");
        if (cl2 instanceof ClassLoader) {
            return (ClassLoader)cl2;
        }
        String className = Thread.currentThread().getStackTrace()[3].getClassName();
        try {
            return Class.forName(className).getClassLoader();
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    public static Object get(Object key) {
        Object value = UIManager.get(key);
        UIDefaultsLookup.log(value, key, null);
        if (value instanceof Map && "Theme.painter".equals(key)) {
            Object o2;
            Map map = (Map)value;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting " + key + " from a map");
                for (Object o3 : map.keySet()) {
                    LOGGER.fine("\t" + o3 + " => " + map.get(o3));
                }
            }
            try {
                Object o3;
                ClassLoader classLoader = UIDefaultsLookup.getCallerClassLoader();
                o3 = map.get(classLoader);
                if (o3 != null && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("\tGetting " + o3 + " using CallerClassLoader" + classLoader);
                }
                while (o3 == null && classLoader.getParent() != null) {
                    o3 = map.get(classLoader = classLoader.getParent());
                    if (o3 == null) continue;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine("\tGetting " + o3 + " using one of the parent ClassLoader " + classLoader);
                    break;
                }
                if (o3 != null) {
                    return o3;
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (map.size() == 1) {
                o2 = map.values().iterator().next();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Failed...getting the only one " + o2);
                }
                return o2;
            }
            o2 = map.get(LookAndFeelFactory.getUIManagerClassLoader());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Failed...getting " + o2 + " using UIManagerClassLoader " + LookAndFeelFactory.getUIManagerClassLoader());
            }
            return o2;
        }
        return value;
    }

    public static Object get(Object key, Locale l2) {
        Object value = UIManager.get(key, l2);
        UIDefaultsLookup.log(value, key, l2);
        return value;
    }

    private static void log(Object value, Object key, Locale l2) {
        if (_debug && value == null) {
            System.out.println("\"" + key + (l2 == null ? "" : l2.toString()) + " \" ==> null ------------------------");
        } else if (_trace) {
            if (value == null) {
                System.out.println("\"" + key + (l2 == null ? "" : l2.toString()) + " \" ==> null ------------------------");
            } else {
                System.out.println("\"" + key + (l2 == null ? "" : l2.toString()) + " \" ==> " + value.getClass().getName() + "(" + ObjectConverterManager.toString(value) + ")");
            }
        }
    }

    public static Font getFont(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Font ? (Font)value : null;
    }

    public static Font getFont(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Font ? (Font)value : null;
    }

    public static Color getColor(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Color ? (Color)value : null;
    }

    public static Color getColor(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Color ? (Color)value : null;
    }

    public static Icon getIcon(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Icon getIcon(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Border getBorder(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Border ? (Border)value : null;
    }

    public static Border getBorder(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Border ? (Border)value : null;
    }

    public static String getString(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof String ? (String)value : null;
    }

    public static String getString(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof String ? (String)value : null;
    }

    public static int getInt(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static int getInt(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static boolean getBoolean(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static boolean getBoolean(Object key, boolean defaultValue) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBoolean(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Insets getInsets(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Insets getInsets(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Dimension getDimension(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Dimension ? (Dimension)value : null;
    }

    public static Dimension getDimension(Object key, Locale l2) {
        Object value = UIDefaultsLookup.get(key, l2);
        return value instanceof Dimension ? (Dimension)value : null;
    }
}

