/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractListIntelliHints;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDataIntelliHints<T>
extends AbstractListIntelliHints {
    private boolean _caseSensitive = false;
    private List<T> _completionList;

    public ListDataIntelliHints(JTextComponent comp, List<T> completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public ListDataIntelliHints(JTextComponent comp, T[] completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public List<T> getCompletionList() {
        return this._completionList;
    }

    public void setCompletionList(List<T> completionList) {
        this._completionList = completionList;
    }

    public void setCompletionList(T[] completionList) {
        final Object[] list = completionList;
        this._completionList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list[index];
            }

            @Override
            public int size() {
                return list.length;
            }
        };
    }

    @Override
    public boolean updateHints(Object context) {
        if (context == null) {
            return false;
        }
        ArrayList<T> possibleHints = new ArrayList<T>();
        for (T o2 : this.getCompletionList()) {
            if (!this.compare(context, o2)) continue;
            possibleHints.add(o2);
        }
        Object[] objects = possibleHints.toArray();
        this.setListData(objects);
        return objects.length > 0;
    }

    protected boolean compare(Object context, T o2) {
        boolean match = false;
        String listEntry = o2 == null ? "" : o2.toString();
        String s2 = context.toString();
        int substringLen = s2.length();
        if (substringLen <= listEntry.length()) {
            if (!this.isCaseSensitive()) {
                if (s2.equalsIgnoreCase(listEntry.substring(0, substringLen))) {
                    match = true;
                }
            } else if (listEntry.startsWith(s2)) {
                match = true;
            }
        }
        return match;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }
}

