/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractPage;
import com.jidesoft.dialog.ButtonEvent;
import com.jidesoft.dialog.ButtonListener;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class AbstractDialogPage
extends AbstractPage {
    private static final long serialVersionUID = -469903356785298291L;
    protected transient ButtonEvent _buttonEvent = null;
    protected String _title;
    protected String _description;
    protected Icon _icon;
    protected boolean _pageEnabled = true;
    protected AbstractDialogPage _parentPage;
    public static final String TITLE_PROPERTY = "title";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String ICON_PROPERTY = "icon";
    public static final String PROPERTY_PAGE_ENABLED = "enabled";
    private Component _defaultFocusComponent;

    protected AbstractDialogPage() {
    }

    public AbstractDialogPage(String title) {
        this._title = title;
    }

    public AbstractDialogPage(String title, String description) {
        this._title = title;
        this._description = description;
    }

    public AbstractDialogPage(String title, Icon icon) {
        this._title = title;
        this._icon = icon;
    }

    public AbstractDialogPage(String title, String description, Icon icon) {
        this._title = title;
        this._icon = icon;
        this._description = description;
    }

    public AbstractDialogPage(String title, String description, Icon icon, AbstractDialogPage parentPage) {
        this._title = title;
        this._icon = icon;
        this._description = description;
        this._parentPage = parentPage;
    }

    public void addButtonListener(ButtonListener l2) {
        this.listenerList.add(ButtonListener.class, l2);
    }

    public void removeButtonListener(ButtonListener l2) {
        this.listenerList.remove(ButtonListener.class, l2);
    }

    public ButtonListener[] getButtonListeners() {
        return (ButtonListener[])this.listenerList.getListeners(ButtonListener.class);
    }

    public void fireButtonEvent(int id) {
        this.fireButtonEvent(id, null, null);
    }

    public void fireButtonEvent(int id, String buttonName) {
        this.fireButtonEvent(id, buttonName, null);
    }

    public void fireButtonEvent(int id, String buttonName, String userObject) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ButtonListener.class) continue;
            if (this._buttonEvent == null) {
                this._buttonEvent = new ButtonEvent(this, id, buttonName, userObject);
            } else {
                this._buttonEvent.setID(id);
                this._buttonEvent.setButtonName(buttonName);
                this._buttonEvent.setUserObject(userObject);
            }
            ((ButtonListener)listeners[i2 + 1]).buttonEventFired(this._buttonEvent);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        String old = this._title;
        this._title = title;
        this.firePropertyChange(TITLE_PROPERTY, old, this._title);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this._icon;
        this._icon = icon;
        this.firePropertyChange(ICON_PROPERTY, old, this._icon);
    }

    public boolean isPageEnabled() {
        return this._pageEnabled;
    }

    public void setPageEnabled(boolean pageEnabled) {
        if (this._pageEnabled != pageEnabled) {
            Boolean oldValue = this._pageEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = pageEnabled ? Boolean.TRUE : Boolean.FALSE;
            this._pageEnabled = pageEnabled;
            this.firePropertyChange(PROPERTY_PAGE_ENABLED, oldValue, newValue);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        String old = this._description;
        this._description = description;
        this.firePropertyChange(DESCRIPTION_PROPERTY, old, this._description);
    }

    public AbstractDialogPage getParentPage() {
        return this._parentPage;
    }

    public void setParentPage(AbstractDialogPage parentPage) {
        this._parentPage = parentPage;
    }

    public String getFullTitle() {
        StringBuffer buffer = new StringBuffer(this.getTitle());
        AbstractDialogPage page = this;
        while (page.getParentPage() != null) {
            AbstractDialogPage parent = page.getParentPage();
            buffer.insert(0, ".");
            buffer.insert(0, parent.getTitle());
            page = parent;
        }
        return new String(buffer);
    }

    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this._defaultFocusComponent = defaultFocusComponent;
    }

    public void focusDefaultFocusComponent() {
        final Component focusComponent = this.getDefaultFocusComponent();
        if (focusComponent != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (focusComponent != null) {
                        focusComponent.requestFocusInWindow();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

