/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.utils.SystemInfo;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat _numberFormat;
    private boolean _avoidNegativeZero;
    public static final ConverterContext CONTEXT_FRACTION_NUMBER = new ConverterContext("Fraction Number");
    private static boolean _groupingUsed = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat format) {
        this._numberFormat = format;
        if (this._numberFormat != null) {
            this._numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        }
    }

    private String trimNegativeSign(String text2) {
        int ch2;
        if (text2.indexOf(45) != 0) {
            return text2;
        }
        for (ch2 = 49; ch2 <= 57; ch2 = (int)((char)(ch2 + 1))) {
            if (text2.indexOf(ch2) < 0) continue;
            return text2;
        }
        for (ch2 = 97; ch2 <= 102; ch2 = (int)((char)(ch2 + 1))) {
            if (text2.indexOf(ch2) < 0) continue;
            return text2;
        }
        for (ch2 = 65; ch2 <= 70; ch2 = (int)((char)(ch2 + 1))) {
            if (text2.indexOf(ch2) < 0) continue;
            return text2;
        }
        if (text2.indexOf(48) < 0) {
            return text2;
        }
        return text2.substring(1);
    }

    public String toString(Object object, ConverterContext context) {
        try {
            if (context == null || context.getUserObject() == null || !(context.getUserObject() instanceof NumberFormat)) {
                if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                    return "";
                }
                String text2 = this.getNumberFormat().format(object);
                if (this.isAvoidNegativeZero()) {
                    text2 = this.trimNegativeSign(text2);
                }
                return text2;
            }
            NumberFormat format = (NumberFormat)context.getUserObject();
            String text3 = format.format(object);
            if (this.isAvoidNegativeZero()) {
                text3 = this.trimNegativeSign(text3);
            }
            return text3;
        }
        catch (IllegalArgumentException e2) {
            return "";
        }
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = DecimalFormat.getInstance();
            this._numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        }
        return this._numberFormat;
    }

    protected NumberFormat getDefaultNumberFormat() {
        NumberFormat format = DecimalFormat.getInstance(Locale.US);
        format.setGroupingUsed(NumberConverter.isGroupingUsed());
        return format;
    }

    protected Number parseNumber(String string2) {
        Number number;
        try {
            number = this.getNumberFormat().parse(string2);
        }
        catch (ParseException e2) {
            try {
                number = this.getDefaultNumberFormat().parse(string2);
            }
            catch (ParseException e1) {
                number = null;
            }
        }
        return number;
    }

    public static boolean isGroupingUsed() {
        return _groupingUsed;
    }

    public static void setGroupingUsed(boolean groupingUsed) {
        _groupingUsed = groupingUsed;
    }

    public void setFractionDigits(int minDigits, int maxDigits) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumFractionDigits(minDigits);
        numberFormat.setMaximumFractionDigits(maxDigits);
    }

    public void setCurrency(Currency currency) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setCurrency(currency);
    }

    public void setIntegerDigits(int minDigits, int maxDigits) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumIntegerDigits(minDigits);
        numberFormat.setMaximumIntegerDigits(maxDigits);
    }

    public void setRoundingMode(RoundingMode mode) {
        if (SystemInfo.isJdk6Above()) {
            NumberFormat numberFormat = this.getNumberFormat();
            numberFormat.setRoundingMode(mode);
        }
    }

    public boolean isAvoidNegativeZero() {
        return this._avoidNegativeZero;
    }

    public void setAvoidNegativeZero(boolean avoidNegativeZero) {
        this._avoidNegativeZero = avoidNegativeZero;
    }
}

