/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.awt.GraphicsEnvironment;

public class FontNameConverter
implements ObjectConverter {
    private boolean _ensureFontExistence = false;
    public static ConverterContext CONTEXT = new ConverterContext("FontName");

    public String toString(Object object, ConverterContext context) {
        if (object == null) {
            return "";
        }
        if (this.isEnsureFontExistence()) {
            String[] fontNames;
            for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!fontName.equals(object)) continue;
                return fontName;
            }
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string2, ConverterContext context) {
        if (string2.length() == 0) {
            return null;
        }
        if (this.isEnsureFontExistence()) {
            String[] fontNames;
            for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!fontName.equals(string2)) continue;
                return string2;
            }
            return null;
        }
        return string2;
    }

    public boolean supportFromString(String string2, ConverterContext context) {
        return true;
    }

    public boolean isEnsureFontExistence() {
        return this._ensureFontExistence;
    }

    public void setEnsureFontExistence(boolean ensureFontExistence) {
        this._ensureFontExistence = ensureFontExistence;
    }
}

