/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.util.Locale;

public class BooleanConverter
implements ObjectConverter {
    public String toString(Object object, ConverterContext context) {
        if (Boolean.FALSE.equals(object)) {
            return this.getFalse();
        }
        if (Boolean.TRUE.equals(object)) {
            return this.getTrue();
        }
        return this.getNull();
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string2, ConverterContext context) {
        if (string2.equalsIgnoreCase(this.getTrue())) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase(this.getFalse())) {
            return Boolean.FALSE;
        }
        if (string2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean supportFromString(String string2, ConverterContext context) {
        return true;
    }

    protected String getTrue() {
        String s2 = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.true");
        return s2 != null ? s2.trim() : s2;
    }

    protected String getFalse() {
        String s2 = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.false");
        return s2 != null ? s2.trim() : s2;
    }

    protected String getNull() {
        return "";
    }
}

