/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.NumberFormatConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class BigDecimalConverter
extends NumberFormatConverter {
    public BigDecimalConverter() {
        super(new DecimalFormat("#,##0.00"));
    }

    public BigDecimalConverter(NumberFormat format) {
        super(format);
    }

    public Object fromString(String string2, ConverterContext context) {
        Object value = super.fromString(string2, context);
        return new BigDecimal("" + value);
    }

    public String toString(Object obj, ConverterContext convertercontext) {
        if (obj instanceof BigDecimal) {
            BigDecimal decimal2 = (BigDecimal)obj;
            if (decimal2.doubleValue() == Double.NaN) {
                return "";
            }
            return super.toString(decimal2, convertercontext);
        }
        return "";
    }
}

