/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.ZyEdgeData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IEdgeRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEdgeRealizer;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEdgeRealizerListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import y.d.m;
import y.i.aY;
import y.i.cb;
import y.i.h;
import y.i.t;

public class ZyEdgeRealizer<EdgeType>
extends cb
implements IZyEdgeRealizer {
    private ZyEdgeData<EdgeType> m_edgeData;
    private IEdgeRealizerUpdater<EdgeType> m_updater;
    private boolean m_drawSloppyEdges = true;
    private boolean m_drawBends = false;
    private boolean m_isHighlighted = false;
    private boolean m_isSloppyPainting = false;
    private final ListenerProvider<IZyEdgeRealizerListener<EdgeType>> m_listeners = new ListenerProvider();
    private ZyLabelContent m_content;

    public ZyEdgeRealizer(ZyLabelContent zyLabelContent, IEdgeRealizerUpdater<EdgeType> iEdgeRealizerUpdater) {
        Preconditions.checkNotNull(zyLabelContent, "Internal Error: Content cannot be null");
        this.m_content = zyLabelContent;
        this.setArrow(h.b);
        this.setSmoothedBends(true);
        if (zyLabelContent.getLineCount() > 0) {
            this.addLabel(new ZyEdgeLabel(zyLabelContent));
        }
        this.setUpdater(iEdgeRealizerUpdater);
    }

    private void notifyLocationChanged() {
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.changedLocation(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void paintHighlightedBends(Graphics2D graphics2D) {
        if (this.m_drawBends && !this.m_isSloppyPainting) {
            super.paintHighlightedBends(graphics2D);
        }
    }

    public void addListener(IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener) {
        this.m_listeners.addListener(iZyEdgeRealizerListener);
    }

    public void addSilent(double d2, double d3) {
        super.appendBend(d2, d3);
    }

    @Override
    public t appendBend(double d2, double d3) {
        t t2 = super.appendBend(d2, d3);
        t2.a(this.isSelected());
        return t2;
    }

    @Override
    public void bendChanged(t t2, double d2, double d3) {
        int n2 = this.bendPos(t2);
        super.bendChanged(t2, d2, d3);
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.bendChanged(n2, t2.b(), t2.c());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void clearBends() {
        super.clearBends();
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.clearedBends();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public ZyLabelContent getEdgeLabelContent() {
        return this.m_content;
    }

    public ZyEdgeData<EdgeType> getUserData() {
        return this.m_edgeData;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.m_content.setSloppy(false);
        this.m_isSloppyPainting = false;
        super.paint(graphics2D);
    }

    @Override
    public void paintBends(Graphics2D graphics2D) {
    }

    @Override
    public void paintPorts(Graphics2D graphics2D) {
    }

    @Override
    public void paintSloppy(Graphics2D graphics2D) {
        this.m_isSloppyPainting = true;
        this.m_content.setSloppy(true);
        if (!this.m_drawSloppyEdges) {
            return;
        }
        if (this.isSelected() || this.m_isHighlighted) {
            aY aY2 = this.getLineType();
            Color color = ZyEdgeRealizer.getSelectionColor();
            this.setLineType(aY.e);
            ZyEdgeRealizer.setSelectionColor(this.getLineColor());
            super.paint(graphics2D);
            this.setLineType(aY2);
            ZyEdgeRealizer.setSelectionColor(color);
        } else {
            super.paintSloppy(graphics2D);
        }
    }

    @Override
    public void regenerate() {
        this.m_content = this.m_updater.generateContent(this);
        this.removeLabel(this.getLabel());
        if (this.m_content.getLineCount() > 0) {
            this.addLabel(new ZyEdgeLabel(this.m_content));
        }
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.regenerated(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.getLabel().repaint();
        this.repaint();
    }

    @Override
    public void reInsertBend(t t2, t t3, int n2) {
        int n3 = this.bendPos(t3) + n2 == 1 || t3 == null ? 0 : 1;
        super.reInsertBend(t2, t3, n2);
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.insertedBend(n3, t2.b(), t2.c());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public t removeBend(t t2) {
        int n2 = this.bendPos(t2);
        t t3 = super.removeBend(t2);
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.removedBend(this, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return t3;
    }

    public void removeListener(IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener) {
        this.m_listeners.removeListener(iZyEdgeRealizerListener);
    }

    public void setDrawBends(boolean bl2) {
        this.m_drawBends = bl2;
    }

    public void setDrawSloppyEdges(boolean bl2) {
        this.m_drawSloppyEdges = bl2;
    }

    @Override
    public void setLineType(aY aY2) {
        this.m_isHighlighted = aY2 == aY.e || aY2 == aY.l || aY2 == aY.q || aY2 == aY.v;
        super.setLineType(aY2);
    }

    @Override
    public void setSelected(boolean bl2) {
        super.setSelected(bl2);
        for (int i2 = 0; i2 < this.bendCount(); ++i2) {
            this.getBend(i2).a(bl2);
        }
    }

    @Override
    public void setSourcePoint(m m2) {
        super.setSourcePoint(m2);
        this.notifyLocationChanged();
    }

    @Override
    public void setTargetPoint(m m2) {
        super.setTargetPoint(m2);
        this.notifyLocationChanged();
    }

    public void setUpdater(IEdgeRealizerUpdater<EdgeType> iEdgeRealizerUpdater) {
        this.m_updater = iEdgeRealizerUpdater;
        if (iEdgeRealizerUpdater != null) {
            iEdgeRealizerUpdater.setRealizer(this);
        }
    }

    public void setUserData(ZyEdgeData<EdgeType> zyEdgeData) {
        this.m_edgeData = zyEdgeData;
    }

    @Override
    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        for (IZyEdgeRealizerListener<EdgeType> iZyEdgeRealizerListener : this.m_listeners) {
            try {
                iZyEdgeRealizerListener.changedVisibility(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

