/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity;

import com.google.security.zynamics.zylib.gui.zygraph.AbstractZyGraphSettings;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.SelectedVisibleFilter;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNodeListener;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.CProximityNode;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettings;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettingsListener;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.ViewableGraph;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ProximityNodeCreator;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import y.c.p;

public class ZyDefaultProximityBrowser<NodeType extends ZyGraphNode<? extends IViewNode<?>>, EdgeType extends ZyGraphEdge<?, ?, ? extends IViewEdge<?>>> {
    private boolean m_internallyDisabled = false;
    private final AbstractZyGraph<NodeType, EdgeType> m_graph;
    private final HashMap<p, ZyProximityNode<?>> m_proximityMap = new HashMap();
    private final IProximitySettings m_settings;
    private Set<NodeType> m_lastShown = new HashSet<NodeType>();
    private final InternalVisibilityListener m_visibilityListener = new InternalVisibilityListener();
    private final InternalSettingsListener m_settingsListener = new InternalSettingsListener();
    private boolean m_changedProximityBrowsing = false;
    private boolean m_doLayout = true;
    private final Map<ZyProximityNode<?>, InternalNodeListener> m_nodeListeners = new HashMap();

    public ZyDefaultProximityBrowser(AbstractZyGraph<NodeType, EdgeType> abstractZyGraph, AbstractZyGraphSettings abstractZyGraphSettings) {
        this.m_graph = abstractZyGraph;
        this.m_settings = abstractZyGraphSettings.getProximitySettings();
        this.addVisibilityListener();
        this.addSettingsListener();
    }

    private void disableProximityBrowsing() {
        if (this.hasAnyHiddenNodes()) {
            this.unhideEverything();
            this.deleteProximityBrowsingNodes();
            this.updateViews();
        }
    }

    private List<NodeType> filterGroupedNodes(List<NodeType> list) {
        return CollectionHelpers.filter(list, new ICollectionFilter<NodeType>(){

            private boolean isOpenGroupNode(NodeType NodeType) {
                return ((ZyGraphNode)NodeType).getRawNode() instanceof IGroupNode && !((IGroupNode)((ZyGraphNode)NodeType).getRawNode()).isCollapsed();
            }

            @Override
            public boolean qualifies(NodeType NodeType) {
                return NodeType == ZyDefaultProximityBrowser.this.getVisibleNode(NodeType) && !this.isOpenGroupNode(NodeType);
            }
        });
    }

    private NodeType getVisibleNode(NodeType NodeType) {
        NodeType NodeType2 = NodeType;
        for (IGroupNode<?, ?> iGroupNode = ((ZyGraphNode)NodeType).getRawNode().getParentGroup(); iGroupNode != null && iGroupNode.isCollapsed(); iGroupNode = iGroupNode.getParentGroup()) {
            NodeType2 = this.m_graph.getNode(iGroupNode);
        }
        return NodeType2;
    }

    private boolean hasAnyHiddenNodes() {
        return GraphHelpers.any(this.m_graph, new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType NodeType) {
                return !((ZyGraphNode)NodeType).isVisible();
            }
        });
    }

    private void restartProximityBrowsing() {
        this.m_lastShown = new HashSet<NodeType>();
        Collection<NodeType> collection = SelectedVisibleFilter.filter(this.m_graph.getSelectedNodes());
        if (!collection.isEmpty()) {
            List list = GraphHelpers.getNodes(this.m_graph);
            list.removeAll(collection);
            this.m_graph.showNodes(collection, list);
            this.updateViews();
        }
    }

    private void setActive() {
        if (!this.m_graph.getSettings().getProximitySettings().getProximityBrowsing()) {
            this.disableProximityBrowsing();
        } else {
            this.restartProximityBrowsing();
        }
    }

    private void unhideEverything() {
        this.m_graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType NodeType) {
                ((ZyGraphNode)NodeType).getRawNode().setVisible(true);
                return IterationMode.CONTINUE;
            }
        });
        this.m_graph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType EdgeType2) {
                ((ZyGraphEdge)EdgeType2).getRawEdge().setVisible(true);
                return IterationMode.CONTINUE;
            }
        });
    }

    private void updateProximityBrowsing(Set<NodeType> set) {
        if (!this.m_graph.getSettings().getProximitySettings().getProximityBrowsing() || this.m_internallyDisabled) {
            return;
        }
        if (this.m_lastShown.equals(set)) {
            return;
        }
        this.m_lastShown = new HashSet<NodeType>(set);
        this.m_internallyDisabled = true;
        this.deleteProximityBrowsingNodes();
        List list = GraphHelpers.getNodes(this.m_graph);
        this.createProximityBrowsingNodes(list);
        this.updateViews();
        this.m_internallyDisabled = false;
    }

    private void updateViews() {
        if (this.m_graph.getSettings().getLayoutSettings().getAutomaticLayouting() && this.m_doLayout) {
            this.m_graph.doLayout();
        }
        this.m_graph.updateViews();
    }

    protected void addSettingsListener() {
        this.m_settings.addListener(this.m_settingsListener);
    }

    protected void addVisibilityListener() {
        this.m_graph.addListener(this.m_visibilityListener);
    }

    protected void createProximityBrowsingNodes(List<NodeType> list) {
        for (ZyGraphNode zyGraphNode : this.filterGroupedNodes(list)) {
            int n2;
            Object object;
            if (!zyGraphNode.isVisible()) continue;
            int n3 = NodeHelpers.countInvisibleIndegreeNeighbours(zyGraphNode.getRawNode());
            if (n3 > 0) {
                ZyProximityNode<?> zyProximityNode = ProximityNodeCreator.createProximityNode(this.m_graph.getGraph(), zyGraphNode, n3, false);
                object = new InternalNodeListener(zyGraphNode.getX(), zyGraphNode.getY(), zyProximityNode);
                zyGraphNode.getRawNode().addListener((IViewNodeListener)object);
                this.m_nodeListeners.put(zyProximityNode, (InternalNodeListener)object);
                this.m_proximityMap.put(zyProximityNode.getNode(), zyProximityNode);
                ProximityNodeCreator.insertProximityEdge(this.m_graph.getGraph(), zyProximityNode, this.getVisibleNode(zyGraphNode));
            }
            if ((n2 = NodeHelpers.countInvisibleOutdegreeNeighbours(zyGraphNode.getRawNode())) <= 0) continue;
            object = ProximityNodeCreator.createProximityNode(this.m_graph.getGraph(), zyGraphNode, n2, true);
            InternalNodeListener internalNodeListener = new InternalNodeListener(zyGraphNode.getX(), zyGraphNode.getY(), (ZyProximityNode<?>)object);
            zyGraphNode.getRawNode().addListener(internalNodeListener);
            this.m_nodeListeners.put((ZyProximityNode<?>)object, internalNodeListener);
            this.m_proximityMap.put(((ZyGraphNode)object).getNode(), (ZyProximityNode<?>)object);
            ProximityNodeCreator.insertProximityEdge(this.m_graph.getGraph(), this.getVisibleNode(zyGraphNode), object);
        }
    }

    protected void deleteProximityBrowsingNode(p p2) {
        ZyProximityNode<?> zyProximityNode = this.m_proximityMap.get(p2);
        this.m_nodeListeners.remove(zyProximityNode);
        this.m_proximityMap.remove(p2);
        this.m_graph.getGraph().a(p2);
    }

    protected void deleteProximityBrowsingNodes() {
        this.m_internallyDisabled = true;
        for (p object : this.m_proximityMap.keySet()) {
            this.m_graph.getGraph().a(object);
        }
        this.m_proximityMap.clear();
        for (Map.Entry entry : this.m_nodeListeners.entrySet()) {
            ((CProximityNode)((ZyProximityNode)entry.getKey()).getRawNode()).getAttachedNode().removeListener((IViewNodeListener)entry.getValue());
        }
        this.m_nodeListeners.clear();
        this.m_internallyDisabled = false;
    }

    protected void removeSettingsListener() {
        this.m_settings.removeListener(this.m_settingsListener);
    }

    protected void removeVisibilityListener() {
        this.m_graph.removeListener(this.m_visibilityListener);
    }

    public void dispose() {
        this.removeVisibilityListener();
        this.removeSettingsListener();
    }

    public void setEnabled(boolean bl2) {
        if (bl2) {
            this.m_graph.getSettings().getProximitySettings().addListener(this.m_settingsListener);
        } else {
            this.m_graph.getSettings().getProximitySettings().removeListener(this.m_settingsListener);
        }
    }

    private class InternalVisibilityListener
    implements IZyGraphVisibilityListener {
        private InternalVisibilityListener() {
        }

        @Override
        public void nodeDeleted() {
            ZyDefaultProximityBrowser.this.m_lastShown.clear();
            Set set = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(ZyDefaultProximityBrowser.this.m_graph));
            ZyDefaultProximityBrowser.this.updateProximityBrowsing(set);
        }

        @Override
        public void visibilityChanged() {
            if (ZyDefaultProximityBrowser.this.m_changedProximityBrowsing) {
                ZyDefaultProximityBrowser.this.m_doLayout = false;
            }
            Set set = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(ZyDefaultProximityBrowser.this.m_graph));
            ZyDefaultProximityBrowser.this.updateProximityBrowsing(set);
            ZyDefaultProximityBrowser.this.m_doLayout = true;
        }
    }

    private class InternalSettingsListener
    implements IProximitySettingsListener {
        private InternalSettingsListener() {
        }

        @Override
        public void changedProximityBrowsing(boolean bl2) {
            ZyDefaultProximityBrowser.this.m_changedProximityBrowsing = true;
            ZyDefaultProximityBrowser.this.setActive();
            ZyDefaultProximityBrowser.this.m_changedProximityBrowsing = false;
            ZyDefaultProximityBrowser.this.m_graph.updateViews();
        }

        @Override
        public void changedProximityBrowsingDepth(int n2, int n3) {
            if (ZyDefaultProximityBrowser.this.m_graph.getSettings().getProximitySettings().getProximityBrowsing()) {
                ZyDefaultProximityBrowser.this.restartProximityBrowsing();
            }
        }

        @Override
        public void changedProximityBrowsingFrozen(boolean bl2) {
        }

        @Override
        public void changedProximityBrowsingPreview(boolean bl2) {
        }
    }

    private class InternalNodeListener
    implements IViewNodeListener {
        private double m_x;
        private double m_y;
        private final ZyProximityNode<?> m_infoNode;

        public InternalNodeListener(double d2, double d3, ZyProximityNode<?> zyProximityNode) {
            this.m_x = d2;
            this.m_y = d3;
            this.m_infoNode = zyProximityNode;
        }

        @Override
        public void changedBorderColor(IViewNode<?> iViewNode, Color color) {
        }

        @Override
        public void changedColor(IViewNode<?> iViewNode, Color color) {
        }

        @Override
        public void changedSelection(IViewNode<?> iViewNode, boolean bl2) {
        }

        @Override
        public void changedVisibility(IViewNode<?> iViewNode, boolean bl2) {
        }

        @Override
        public void heightChanged(IViewNode<?> iViewNode, double d2) {
        }

        @Override
        public void widthChanged(IViewNode<?> iViewNode, double d2) {
        }

        @Override
        public void xposChanged(IViewNode<?> iViewNode, double d2) {
            this.m_infoNode.getRealizer().setX(this.m_infoNode.getX() + d2 - this.m_x);
            this.m_x = d2;
        }

        @Override
        public void yposChanged(IViewNode<?> iViewNode, double d2) {
            this.m_infoNode.getRealizer().setY(this.m_infoNode.getY() + d2 - this.m_y);
            this.m_y = d2;
        }
    }
}

