/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ZoomHelpers;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import y.d.p;
import y.i.N;
import y.i.bO;

public class ZoomFunctions {
    public static <EdgeType extends ZyGraphEdge<?, ?, ?>> void zoomToEdgeLabel(AbstractZyGraph<?, EdgeType> abstractZyGraph, EdgeType EdgeType2) {
        N n2 = EdgeType2.getRealizer().getLabel();
        p p2 = n2.getBox();
        Rectangle rectangle = abstractZyGraph.getView().getBounds();
        double d2 = rectangle.getWidth() / p2.a();
        double d3 = rectangle.getHeight() / p2.b();
        double d4 = abstractZyGraph.getView().getZoom();
        abstractZyGraph.getView().setZoom(0.8 * Math.min(d2, d3));
        ZoomHelpers.keepZoomValid(abstractZyGraph.getView());
        double d5 = abstractZyGraph.getView().getZoom();
        abstractZyGraph.getView().setZoom(d4);
        Point2D.Double double_ = new Point2D.Double(p2.c() + 0.5 * p2.a(), p2.d() + 0.5 * p2.b());
        abstractZyGraph.getView().focusView(d5, double_, true);
        abstractZyGraph.updateViews();
    }

    public static <NodeType extends ZyGraphNode<?>> void zoomToNode(AbstractZyGraph<NodeType, ?> abstractZyGraph, NodeType NodeType) {
        Preconditions.checkNotNull(NodeType, "Error: Node argument can't be null");
        bO bO2 = abstractZyGraph.getGraph().t(NodeType.getNode());
        Preconditions.checkNotNull(bO2, "Error: Node does not belong to the graph");
        if (!NodeType.isVisible()) {
            abstractZyGraph.showNode(NodeType, true);
        }
        double d2 = abstractZyGraph.getView().getZoom();
        Point2D point2D = abstractZyGraph.getView().getViewPoint2D();
        abstractZyGraph.getView().zoomToArea(bO2.getCenterX() - bO2.getWidth(), bO2.getCenterY() - bO2.getHeight(), bO2.getWidth() * 2.0, bO2.getHeight() * 2.0);
        ZoomHelpers.keepZoomValid(abstractZyGraph.getView());
        double d3 = abstractZyGraph.getView().getZoom();
        Point2D point2D2 = abstractZyGraph.getView().getCenter();
        abstractZyGraph.getView().setZoom(d2);
        abstractZyGraph.getView().setViewPoint((int)point2D.getX(), (int)point2D.getY());
        abstractZyGraph.getView().focusView(d3, point2D2, abstractZyGraph.getSettings().getLayoutSettings().getAnimateLayout());
        abstractZyGraph.updateViews();
    }

    public static <NodeType extends ZyGraphNode<?>> void zoomToNode(AbstractZyGraph<NodeType, ?> abstractZyGraph, NodeType NodeType, int n2, boolean bl2) {
        Preconditions.checkNotNull(NodeType, "Error: Node argument can't be null");
        IZyNodeRealizer iZyNodeRealizer = NodeType.getRealizer();
        Preconditions.checkNotNull(iZyNodeRealizer, "Error: Node does not belong to the graph");
        double d2 = iZyNodeRealizer.getNodeContent().getLineHeight() * (double)n2;
        Point2D point2D = abstractZyGraph.getView().getViewPoint2D();
        abstractZyGraph.getView().setCenter(iZyNodeRealizer.getCenterX(), iZyNodeRealizer.getCenterY() - iZyNodeRealizer.getHeight() / 2.0 + d2);
        if (bl2) {
            Point2D point2D2 = abstractZyGraph.getView().getCenter();
            abstractZyGraph.getView().setViewPoint((int)point2D.getX(), (int)point2D.getY());
            abstractZyGraph.getView().focusView(abstractZyGraph.getView().getZoom(), point2D2, abstractZyGraph.getSettings().getLayoutSettings().getAnimateLayout());
        }
        abstractZyGraph.updateViews();
    }

    public static <NodeType extends ZyGraphNode<?>> void zoomToNodes(AbstractZyGraph<NodeType, ?> abstractZyGraph, Collection<NodeType> collection) {
        Preconditions.checkNotNull(collection, "Error: nodes argument can not be null");
        if (collection.size() == 0) {
            return;
        }
        double d2 = abstractZyGraph.getView().getZoom();
        Point2D point2D = abstractZyGraph.getView().getViewPoint2D();
        Rectangle2D rectangle2D = GraphHelpers.calculateBoundingBox(collection);
        abstractZyGraph.getView().zoomToArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        ZoomHelpers.keepZoomValid(abstractZyGraph.getView());
        abstractZyGraph.zoomOut();
        double d3 = abstractZyGraph.getView().getZoom();
        Point2D point2D2 = abstractZyGraph.getView().getCenter();
        abstractZyGraph.getView().setZoom(d2);
        abstractZyGraph.getView().setViewPoint((int)point2D.getX(), (int)point2D.getY());
        abstractZyGraph.getView().focusView(d3, point2D2, abstractZyGraph.getSettings().getLayoutSettings().getAnimateLayout());
        abstractZyGraph.updateViews();
    }

    public static void zoomToScreen(AbstractZyGraph<?, ?> abstractZyGraph) {
        abstractZyGraph.getView().fitContent();
        ZoomHelpers.keepZoomValid(abstractZyGraph.getView());
        abstractZyGraph.updateViews();
    }
}

