/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IBendListener;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdgeListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEdgeRealizerListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import java.awt.Color;
import java.util.ArrayList;
import y.c.d;
import y.d.m;
import y.i.O;
import y.i.U;
import y.i.a.p;
import y.i.t;

public class ZyGraphEdge<NodeTypeT extends ZyGraphNode<?>, EdgeTypeT extends ZyGraphEdge<?, ?, ?>, RawEdgeTypeT extends IViewEdge<?>> {
    private d m_edge;
    private RawEdgeTypeT m_rawEdge;
    private final InternalListener m_listener = new InternalListener();
    private final ZyEdgeRealizer<EdgeTypeT> m_realizer;
    private final U m_graph;
    private final NodeTypeT m_targetNode;
    private final NodeTypeT m_sourceNode;

    public ZyGraphEdge(NodeTypeT NodeTypeT, NodeTypeT NodeTypeT2, d d2, ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer, RawEdgeTypeT RawEdgeTypeT) {
        Preconditions.checkNotNull(NodeTypeT, "Source node cannot be null");
        Preconditions.checkNotNull(NodeTypeT2, "Target node cannot be null");
        Preconditions.checkNotNull(d2, "Edge argument cannot be null");
        Preconditions.checkNotNull(RawEdgeTypeT, "Raw edge argument cannot be null");
        this.m_sourceNode = NodeTypeT;
        this.m_targetNode = NodeTypeT2;
        this.m_edge = d2;
        this.m_rawEdge = RawEdgeTypeT;
        this.m_realizer = zyEdgeRealizer;
        this.m_realizer.setSelected(RawEdgeTypeT.isSelected());
        this.m_realizer.setSourcePoint(new m(RawEdgeTypeT.getX1(), RawEdgeTypeT.getY1()));
        this.m_realizer.setTargetPoint(new m(RawEdgeTypeT.getX2(), RawEdgeTypeT.getY2()));
        this.m_graph = (U)d2.a();
        this.m_graph.a(d2, zyEdgeRealizer);
        for (CBend cBend : this.m_rawEdge.getBends()) {
            this.m_realizer.addPoint(cBend.getX(), cBend.getY());
            cBend.addListener(this.m_listener);
        }
        zyEdgeRealizer.addListener(this.m_listener);
        RawEdgeTypeT.addListener(this.m_listener);
    }

    private static U getGraph(d d2) {
        return (U)d2.a();
    }

    private ZyEdgeRealizer<EdgeTypeT> getRealizer(d d2) {
        ZyEdgeRealizer zyEdgeRealizer = (ZyEdgeRealizer)ZyGraphEdge.getGraph(d2).i(d2);
        Preconditions.checkState(zyEdgeRealizer != null, "Node does not have a realizer");
        return zyEdgeRealizer;
    }

    private void updateViews() {
        if (ZyGraphEdge.getGraph(this.m_edge) != null) {
            ZyGraphEdge.getGraph(this.m_edge).S();
        }
    }

    public void addPath(double d2, double d3) {
        this.getRealizer(this.m_edge).addPoint(d2, d3);
    }

    public void dispose() {
        for (CBend cBend : this.m_rawEdge.getBends()) {
            cBend.removeListener(this.m_listener);
        }
        this.m_realizer.removeListener(this.m_listener);
        this.m_rawEdge.removeListener(this.m_listener);
    }

    public d getEdge() {
        return this.m_edge;
    }

    public ArrayList<Pair<Double, Double>> getPaths() {
        int n2 = this.getRealizer(this.m_edge).pointCount();
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>();
        for (int i2 = 0; i2 < n2; ++i2) {
            m m2 = this.getRealizer(this.m_edge).getPoint(i2);
            arrayList.add(new Pair<Double, Double>(m2.a, m2.b));
        }
        return arrayList;
    }

    public RawEdgeTypeT getRawEdge() {
        return this.m_rawEdge;
    }

    public ZyEdgeRealizer<EdgeTypeT> getRealizer() {
        return this.m_realizer;
    }

    public NodeTypeT getSource() {
        return this.m_sourceNode;
    }

    public NodeTypeT getTarget() {
        return this.m_targetNode;
    }

    public double getX1() {
        return this.getRealizer((d)this.m_edge).getSourcePoint().a;
    }

    public double getX2() {
        return this.getRealizer((d)this.m_edge).getTargetPoint().a;
    }

    public double getY1() {
        return this.getRealizer((d)this.m_edge).getSourcePoint().b;
    }

    public double getY2() {
        return this.getRealizer((d)this.m_edge).getTargetPoint().b;
    }

    public boolean isSelected() {
        return this.m_realizer.isSelected();
    }

    public boolean isVisible() {
        return this.m_edge.a() != null;
    }

    public void setRawEdge(RawEdgeTypeT RawEdgeTypeT) {
        this.m_rawEdge.removeListener(this.m_listener);
        this.m_rawEdge = RawEdgeTypeT;
        this.m_rawEdge.addListener(this.m_listener);
    }

    public void setX1(double d2) {
        this.getRealizer(this.m_edge).setSourcePoint(new m(d2, this.getY1()));
    }

    public void setX2(double d2) {
        this.getRealizer(this.m_edge).setTargetPoint(new m(d2, this.getY2()));
    }

    public void setY1(double d2) {
        this.getRealizer(this.m_edge).setSourcePoint(new m(this.getX1(), d2));
    }

    public void setY2(double d2) {
        this.getRealizer(this.m_edge).setTargetPoint(new m(this.getX2(), d2));
    }

    private class InternalListener
    implements IBendListener,
    IViewEdgeListener,
    IZyEdgeRealizerListener<EdgeTypeT> {
        private InternalListener() {
        }

        @Override
        public void addedBend(double d2, double d3) {
            ZyGraphEdge.this.m_rawEdge.addBend(d2, d3);
        }

        @Override
        public void addedBend(IViewEdge<?> iViewEdge, CBend cBend) {
            cBend.addListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == iViewEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_realizer.appendBend(cBend.getX(), cBend.getY());
        }

        @Override
        public void bendChanged(int n2, double d2, double d3) {
            CBend cBend = ZyGraphEdge.this.m_rawEdge.getBends().get(n2);
            cBend.setX(d2);
            cBend.setY(d3);
        }

        @Override
        public void changedColor(CViewEdge<?> cViewEdge, Color color) {
            ZyGraphEdge.this.m_realizer.setLineColor(color);
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedLocation(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
            m m2 = zyEdgeRealizer.getSourcePoint();
            ZyGraphEdge.this.m_rawEdge.setX1(m2.a);
            ZyGraphEdge.this.m_rawEdge.setY1(m2.b);
            m m3 = zyEdgeRealizer.getTargetPoint();
            ZyGraphEdge.this.m_rawEdge.setX2(m3.a);
            ZyGraphEdge.this.m_rawEdge.setY2(m3.b);
        }

        @Override
        public void changedSelection(IViewEdge<?> iViewEdge, boolean bl2) {
            ZyGraphEdge.this.m_realizer.setSelected(bl2);
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedSourceX(CViewEdge<?> cViewEdge, double d2) {
            m m2 = ZyGraphEdge.this.m_realizer.getSourcePoint();
            ZyGraphEdge.this.m_realizer.setSourcePoint(new m(d2, m2.b));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedSourceY(CViewEdge<?> cViewEdge, double d2) {
            m m2 = ZyGraphEdge.this.m_realizer.getSourcePoint();
            ZyGraphEdge.this.m_realizer.setSourcePoint(new m(m2.a, d2));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedTargetX(CViewEdge<?> cViewEdge, double d2) {
            m m2 = ZyGraphEdge.this.m_realizer.getTargetPoint();
            ZyGraphEdge.this.m_realizer.setTargetPoint(new m(d2, m2.b));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedTargetY(CViewEdge<?> cViewEdge, double d2) {
            m m2 = ZyGraphEdge.this.m_realizer.getTargetPoint();
            ZyGraphEdge.this.m_realizer.setTargetPoint(new m(m2.a, d2));
            ZyGraphEdge.this.updateViews();
        }

        @Override
        public void changedType(CViewEdge<?> cViewEdge, EdgeType edgeType) {
        }

        @Override
        public void changedVisibility(IViewEdge<?> iViewEdge, boolean bl2) {
            if (bl2) {
                y.c.p p2 = ZyGraphEdge.this.m_sourceNode.getNode();
                y.c.p p3 = ZyGraphEdge.this.m_targetNode.getNode();
                if (p2.e() == null || p3.e() == null) {
                    return;
                }
                p p4 = ZyGraphEdge.this.m_graph.C();
                d d2 = p4.a(p2, p3);
                ZyGraphEdge.this.m_graph.a(d2, (O)ZyGraphEdge.this.m_realizer);
                ZyGraphEdge.this.m_edge = d2;
            } else if (ZyGraphEdge.this.m_edge.a() == ZyGraphEdge.this.m_graph) {
                ZyGraphEdge.this.m_graph.a(ZyGraphEdge.this.m_edge);
            }
        }

        @Override
        public void changedVisibility(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
            ZyGraphEdge.this.m_rawEdge.setVisible(zyEdgeRealizer.isVisible());
        }

        @Override
        public void changedX(CBend cBend, double d2) {
            int n2 = ZyGraphEdge.this.m_rawEdge.getBends().indexOf(cBend);
            t t2 = ZyGraphEdge.this.m_realizer.getBend(n2);
            t2.a(d2, t2.c());
        }

        @Override
        public void changedY(CBend cBend, double d2) {
            int n2 = ZyGraphEdge.this.m_rawEdge.getBends().indexOf(cBend);
            t t2 = ZyGraphEdge.this.m_realizer.getBend(n2);
            t2.a(t2.b(), d2);
        }

        @Override
        public void clearedBends() {
            for (CBend cBend : ZyGraphEdge.this.m_rawEdge.getBends()) {
                cBend.removeListener(this);
            }
            ZyGraphEdge.this.m_rawEdge.clearBends();
        }

        @Override
        public void clearedBends(IViewEdge<?> iViewEdge) {
            if (ZyGraphEdge.this.m_realizer.bendCount() != 0) {
                ZyGraphEdge.this.m_realizer.clearBends();
            }
        }

        @Override
        public void insertedBend(int n2, double d2, double d3) {
            if (ZyGraphEdge.this.m_realizer.bendCount() == ZyGraphEdge.this.m_rawEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_rawEdge.insertBend(n2, d2, d3);
        }

        @Override
        public void insertedBend(IViewEdge<?> iViewEdge, int n2, CBend cBend) {
            Preconditions.checkNotNull(iViewEdge, "Edge cannot be null");
            Preconditions.checkNotNull(cBend, "Error: bend argument can not be null");
            cBend.addListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == iViewEdge.getBendCount()) {
                return;
            }
            if (iViewEdge == this) {
                ZyGraphEdge.this.m_realizer.insertBend(cBend.getX(), cBend.getY());
            }
        }

        @Override
        public void regenerated(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer) {
        }

        @Override
        public void removedBend(CViewEdge<?> cViewEdge, int n2, CBend cBend) {
            cBend.removeListener(ZyGraphEdge.this.m_listener);
            if (ZyGraphEdge.this.m_realizer.bendCount() == ZyGraphEdge.this.m_rawEdge.getBendCount()) {
                return;
            }
            ZyGraphEdge.this.m_realizer.removeBend(ZyGraphEdge.this.m_realizer.getBend(n2));
        }

        @Override
        public void removedBend(ZyEdgeRealizer<EdgeTypeT> zyEdgeRealizer, int n2) {
            ZyGraphEdge.this.m_rawEdge.removeBend(n2);
        }
    }
}

