/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.trees;

import com.google.common.collect.Sets;
import com.google.security.zynamics.zylib.types.trees.DepthFirstIterator;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TreeAlgorithms {
    public static <ObjectType> boolean dominates(ITreeNode<ObjectType> node, ITreeNode<ObjectType> target, ITreeNode<ObjectType> source) {
        if (node.getObject() == source) {
            return false;
        }
        if (node.getObject() == target) {
            return true;
        }
        for (ITreeNode<ObjectType> child : node.getChildren()) {
            if (TreeAlgorithms.dominates(child, target, source)) continue;
            return false;
        }
        return true;
    }

    public static <NodeType> HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> getDominateRelation(ITreeNode<NodeType> treeNode) {
        HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> dominationRelation = new HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>>();
        HashSet<ITreeNode<NodeType>> hashSet = new HashSet<ITreeNode<NodeType>>();
        hashSet.add(treeNode);
        dominationRelation.put(treeNode, hashSet);
        DepthFirstIterator<NodeType> iter = new DepthFirstIterator<NodeType>(treeNode);
        while (iter.hasNext()) {
            Object currentTreeElement = iter.next();
            ITreeNode currentTreeElementParent = currentTreeElement.getParent();
            HashSet<Object> currentTreeElementParents = Sets.newHashSet((Iterable)dominationRelation.get(currentTreeElementParent));
            currentTreeElementParents.add(currentTreeElementParent);
            currentTreeElementParents.add(currentTreeElement);
            dominationRelation.put((ITreeNode<NodeType>)currentTreeElement, (Set<ITreeNode<NodeType>>)currentTreeElementParents);
        }
        return dominationRelation;
    }
}

