/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.trees;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.Iterator;
import java.util.Stack;

public class DepthFirstIterator<ObjectType>
implements Iterator<ITreeNode<ObjectType>> {
    private final Stack<ITreeNode<ObjectType>> m_path = new Stack();

    public DepthFirstIterator(ITreeNode<ObjectType> rootNode) {
        Preconditions.checkNotNull(rootNode, "Error: Root node argument can not be null");
        for (ITreeNode<ObjectType> treeNode : rootNode.getChildren()) {
            this.m_path.add(treeNode);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.m_path.isEmpty();
    }

    @Override
    public ITreeNode<ObjectType> next() {
        ITreeNode<ObjectType> current = this.m_path.pop();
        for (ITreeNode<ObjectType> child : current.getChildren()) {
            this.m_path.add(child);
        }
        return current;
    }

    @Override
    public void remove() {
    }
}

