/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DirectedGraph<NodeType extends IGraphNode<NodeType>, EdgeType extends IGraphEdge<NodeType>>
implements Iterable<NodeType>,
IDirectedGraph<NodeType, EdgeType> {
    private final List<NodeType> m_nodes;
    private final List<EdgeType> m_edges;
    private final HashMultimap<NodeType, EdgeType> m_incomingEdges = HashMultimap.create();
    private final HashMultimap<NodeType, EdgeType> m_outgoingEdges = HashMultimap.create();

    public DirectedGraph(List<NodeType> nodes, List<EdgeType> edges) {
        Preconditions.checkNotNull(nodes, "Error: Nodes argument can not be null");
        Preconditions.checkNotNull(edges, "Error: Edges argument can not be null");
        for (IGraphNode node : nodes) {
            Preconditions.checkNotNull(node, "Error: Node list contains null-nodes");
        }
        for (IGraphEdge edge : edges) {
            this.m_outgoingEdges.put(edge.getSource(), edge);
            this.m_incomingEdges.put(edge.getTarget(), edge);
        }
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    @Override
    public int edgeCount() {
        return this.m_edges.size();
    }

    @Override
    public List<EdgeType> getEdges() {
        return Collections.unmodifiableList(this.m_edges);
    }

    public Set<EdgeType> getIncomingEdges(NodeType node) {
        return this.m_incomingEdges.get((Object)node);
    }

    @Override
    public List<NodeType> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    public Set<EdgeType> getOutgoingEdges(NodeType node) {
        return this.m_outgoingEdges.get((Object)node);
    }

    @Override
    public Iterator<NodeType> iterator() {
        return this.m_nodes.iterator();
    }

    @Override
    public int nodeCount() {
        return this.m_nodes.size();
    }
}

