/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.strings;

import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;

public class CircularStringBuffer {
    private final Queue<String> m_buffer = new LinkedList<String>();
    private final int m_maxSize;

    public CircularStringBuffer(int maxLines) {
        this.m_maxSize = maxLines;
    }

    private void addToBuffer(String[] lines) {
        boolean index = false;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            while (this.m_maxSize - this.m_buffer.size() <= 0) {
                this.m_buffer.remove();
            }
            this.m_buffer.add(lines[0]);
        }
    }

    public void add(String text2) {
        String[] lines = text2.split("\n");
        if (lines.length > 0) {
            this.addToBuffer(lines);
        } else {
            this.addToBuffer(new String[]{text2});
        }
    }

    public int getSize() {
        return this.m_buffer.size();
    }

    public String getText() {
        return this.m_buffer.stream().collect(Collectors.joining("\n", "", "\n"));
    }
}

