/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.io;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.io.StreamUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class FileUtils {
    public static String calcMD5(File file) throws IOException {
        MessageDigest md;
        FileInputStream reader = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        reader.read(data);
        reader.close();
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            assert (false) : "MD5 not in list of algorithms";
            throw new RuntimeException(e2);
        }
        md.update(data);
        byte[] digest = md.digest();
        StringBuilder md52 = new StringBuilder();
        for (byte b2 : digest) {
            md52.append(String.format("%02X", b2));
        }
        return md52.toString();
    }

    public static boolean containsDirectory(File directory, String filename) {
        if (directory == null || !directory.isDirectory()) {
            return false;
        }
        for (File file : directory.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(File directory, String filename) {
        if (directory == null || !directory.isDirectory()) {
            return false;
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().equals(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean createDirectory(String directory) {
        return new File(directory).mkdirs();
    }

    public static String ensureTrailingSlash(String path) {
        if (path == null || path.equals("")) {
            return "";
        }
        StringBuilder buf = new StringBuilder(path);
        while (buf.charAt(buf.length() - 1) == File.separatorChar) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.append(File.separatorChar).toString();
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static String extractNameFromPath(String name) {
        return new File(name).getName();
    }

    public static String findLocalRootPath(Class<?> klazz) {
        String result;
        int startIdx;
        String compiledFileName = String.valueOf(klazz.getSimpleName()).concat(".class");
        URL classUrl = klazz.getResource(compiledFileName);
        String string2 = String.valueOf(klazz.getCanonicalName());
        Preconditions.checkNotNull(classUrl, string2.length() != 0 ? "Cannot find resource for class ".concat(string2) : new String("Cannot find resource for class "));
        String classUrlProto = classUrl.getProtocol();
        String classUrlPath = classUrl.getPath();
        int n2 = startIdx = SystemHelpers.isRunningWindows() ? 1 : 0;
        if (classUrlProto.equals("file")) {
            Package classPackage = klazz.getPackage();
            if (classPackage != null) {
                String classPackagePath = classPackage != null ? classPackage.getName().replace('.', '/') : "";
                result = classUrlPath.substring(startIdx, classUrlPath.lastIndexOf(classPackagePath));
            } else {
                result = classUrlPath.substring(startIdx, classUrlPath.lastIndexOf(47));
            }
        } else {
            if (!classUrlProto.equals("jar")) {
                throw new RuntimeException("Cannot find root path for remote classes");
            }
            if (!classUrlPath.startsWith("file:")) {
                String string3 = String.valueOf(klazz.getCanonicalName());
                throw new IllegalArgumentException(string3.length() != 0 ? "Cannot find root path for class ".concat(string3) : new String("Cannot find root path for class "));
            }
            String jarPath = classUrlPath.substring(5, classUrlPath.lastIndexOf(33));
            result = jarPath.substring(startIdx, jarPath.lastIndexOf(47));
        }
        try {
            return URLDecoder.decode(result.replace('/', File.separatorChar), System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException e2) {
            assert (false) : "Platform default URL encoding should always be available";
            throw new RuntimeException(e2);
        }
    }

    public static String getFileBasename(File file) {
        String filename = file.getName();
        int dotIdx = filename.lastIndexOf(".");
        return dotIdx == -1 ? filename : filename.substring(0, dotIdx);
    }

    public static String getFileExtension(File file) {
        String filename = file.getAbsolutePath();
        return filename.substring(filename.lastIndexOf(".") + 1);
    }

    public static String getPathEllipsis(String filename, int maxlen) {
        return FileUtils.getPathEllipsis(filename, maxlen, "...");
    }

    public static String getPathEllipsis(String filename, int maxlen, String ellipsis) {
        int len = filename.length();
        int ellLen = ellipsis.length();
        Preconditions.checkArgument(maxlen >= 4 * ellLen, "Maximum length too short");
        if (len <= maxlen) {
            return filename;
        }
        char sep = File.separatorChar;
        boolean found = false;
        for (int i2 = 0; !found && i2 < len; ++i2) {
            sep = filename.charAt(i2);
            found = sep == '/' || sep == '\\';
        }
        StringBuilder result = new StringBuilder();
        if (!found) {
            result.append(filename.substring(0, maxlen - ellLen));
            result.append(ellipsis);
        } else {
            int lastComp = filename.lastIndexOf(sep);
            int splitLen = maxlen - (len - lastComp);
            int splitPos = splitLen / 2 - ellLen / 2;
            if (splitPos > 0) {
                result.append(filename.substring(0, splitPos - ellLen % 2 + splitLen % 2));
                result.append(ellipsis);
                result.append(filename.substring(lastComp - splitPos + ellLen % 2));
            } else {
                result.append(filename.substring(0, 3));
                result.append(ellipsis);
                result.append(filename.substring(lastComp, lastComp + maxlen - 3 - 2 * ellLen));
                result.append(ellipsis);
            }
        }
        return result.toString();
    }

    public static String readTextfile(File file) throws IOException {
        StringBuffer contents = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(lineSeparator);
            }
        }
        return contents.toString();
    }

    public static String readTextfile(String filename) throws IOException {
        return FileUtils.readTextfile(new File(filename));
    }

    public static List<String> readTextfileLines(File file) throws IOException {
        return StreamUtils.readLinesFromReader(new FileReader(file));
    }

    public static void writeBinaryFile(File file, byte[] data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
        }
    }

    public static void writeTextFile(File file, String text2) throws IOException {
        Preconditions.checkNotNull(file, "Error: file argument can not be null");
        Preconditions.checkNotNull(text2, "Error: text argument can not be null");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(text2);
        }
    }
}

