/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CHighlighting;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZyLineContent {
    private static final FontRenderContext m_fontContext = new FontRenderContext(null, true, true);
    private static final Composite DEFAULT_COMPOSITE = AlphaComposite.getInstance(3, 0.3f);
    private static final Composite NORMAL_COMPOSITE = AlphaComposite.getInstance(3, 1.0f);
    private static final Stroke DEFAULT_BORDER_STROKE = new BasicStroke(1.2f);
    private static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private String m_text;
    private AttributedString m_atext;
    private double m_charWidth;
    private double m_charHeight;
    private TextLayout m_textLayout;
    private final ArrayList<CHighlighting> m_highlighting = new ArrayList();
    private final List<IZyEditableObject> m_lineObjects = new ArrayList<IZyEditableObject>();
    private final IZyEditableObject m_model;
    private Color m_backgroundColor = null;
    private final List<ObjectWrapper> m_objects = new ArrayList<ObjectWrapper>();

    public ZyLineContent(String text2, Font font, IZyEditableObject model) {
        this(text2, font, new ArrayList<CStyleRunData>(), model);
    }

    public ZyLineContent(String text2, Font font, List<CStyleRunData> textColorStyleRun, IZyEditableObject model) {
        Preconditions.checkNotNull(text2, "Error: Text argument can't be null");
        Preconditions.checkNotNull(textColorStyleRun, "Error: Text color style run can't be null.");
        this.m_model = model;
        this.regenerateLine(text2, font, textColorStyleRun);
    }

    public ZyLineContent(String text2, IZyEditableObject model) {
        this(text2, null, model);
    }

    private int calculateRealLength(int position, int length) {
        return length != -1 ? length : this.m_text.length() - position;
    }

    private void drawHighlighting(Graphics2D gfx, double x2, double y2, double width, double height, Color color) {
        gfx.setColor(color);
        int roundedX = (int)Math.round(x2);
        int roundedY = (int)Math.round(y2);
        int roundedHeight = (int)Math.round(height);
        int roundedWidth = (int)Math.round(width);
        gfx.setComposite(DEFAULT_COMPOSITE);
        gfx.fillRoundRect(roundedX, roundedY, roundedWidth, roundedHeight, 10, 10);
        gfx.setColor(color.darker());
        gfx.setStroke(DEFAULT_BORDER_STROKE);
        gfx.drawRoundRect(roundedX, roundedY, roundedWidth, roundedHeight, 10, 10);
        gfx.setComposite(NORMAL_COMPOSITE);
        gfx.setStroke(NORMAL_STROKE);
    }

    private void regenerateLine(String text2, Font font, List<CStyleRunData> textColorStyleRun) {
        this.m_text = Preconditions.checkNotNull(text2, "Error: text argument can not be null");
        Preconditions.checkNotNull(textColorStyleRun, "Error: textColorStyleRun argument can not be null");
        this.m_atext = new AttributedString(text2);
        if (!this.isEmpty()) {
            if (font != null) {
                this.m_atext.addAttribute(TextAttribute.FONT, font);
            }
            for (CStyleRunData data : textColorStyleRun) {
                int position = data.getStart();
                int realLength = this.calculateRealLength(position, data.getLength());
                this.validatePartialLineArguments(position, realLength);
                this.m_atext.addAttribute(TextAttribute.FOREGROUND, data.getColor(), position, position + realLength);
                if (data.getLineObject() != null) {
                    this.m_lineObjects.add(data.getLineObject());
                }
                if (data.getObject() == null) continue;
                this.setObject(position, realLength, data.getObject());
            }
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
        if (font != null) {
            this.updateCharBounds(font);
        }
    }

    private void updateCharBounds(Font font) {
        this.m_charWidth = font.getStringBounds(this.m_text, m_fontContext).getWidth() / (double)this.getTextLayout().getCharacterCount();
        this.m_charHeight = font.getLineMetrics(this.m_text, m_fontContext).getHeight();
    }

    private void validatePartialLineArguments(int position, int length) {
        Preconditions.checkArgument(position >= 0 && position < this.m_text.length(), "Error: Position argument is out of bounds (Position: %d, Length: %d/%d)", position, length, this.m_text.length());
        Preconditions.checkArgument(length > 0 || position + length <= this.m_text.length(), "Error: Length argument is out of bounds (Position: %d, Length: %d)", position, length);
    }

    public synchronized boolean clearHighlighting(int level) {
        if (this.m_highlighting.isEmpty()) {
            return false;
        }
        for (CHighlighting highlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (highlighting.getLevel() != level) continue;
            this.m_highlighting.remove(highlighting);
            return true;
        }
        return false;
    }

    public synchronized void draw(Graphics2D gfx, float x2, float y2) {
        if (!this.isEmpty()) {
            this.m_textLayout.draw(gfx, x2, y2);
            for (CHighlighting highlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
                double bpX = (double)x2 + highlighting.getStart() - 2.0;
                double bpY = (double)y2 - this.m_charHeight + 4.0;
                double bpW = highlighting.getEnd() + 4.0;
                double bpH = this.m_charHeight - 1.0;
                this.drawHighlighting(gfx, bpX, bpY, bpW, bpH, highlighting.getColor());
            }
        }
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public List<CStyleRunData> getBackgroundStyleRunData(int start, int end) {
        Preconditions.checkState(start >= 0 && start <= end && start < this.m_text.length(), "Illegal start value.");
        Preconditions.checkState(end >= 0 && end >= start && end < this.m_text.length(), "Illegal end value.");
        ArrayList<CStyleRunData> styleRun = new ArrayList<CStyleRunData>();
        AttributedCharacterIterator iterator = this.m_atext.getIterator();
        iterator.setIndex(start);
        Color lastColor = null;
        int attributeStart = start;
        for (int i2 = start; i2 <= end; ++i2) {
            Color color = (Color)iterator.getAttribute(TextAttribute.BACKGROUND);
            if (color != null && !color.equals(lastColor) || lastColor != null && !lastColor.equals(color)) {
                if (lastColor != null) {
                    CStyleRunData data = new CStyleRunData(attributeStart, i2 - attributeStart + 1, lastColor);
                    styleRun.add(data);
                }
                lastColor = color;
                attributeStart = i2;
            }
            iterator.next();
        }
        CStyleRunData data = new CStyleRunData(attributeStart, end - attributeStart + 1, lastColor);
        styleRun.add(data);
        return styleRun;
    }

    public Rectangle2D getBounds() {
        if (this.isEmpty()) {
            AttributedString dummyString = new AttributedString(" ");
            TextLayout dummyLayout = new TextLayout(dummyString.getIterator(), m_fontContext);
            return dummyLayout.getBounds();
        }
        return new Rectangle2D.Double(0.0, 0.0, this.m_charWidth * (double)this.m_text.length(), this.m_charHeight);
    }

    public double getCharWidth() {
        return this.m_charWidth;
    }

    public IZyEditableObject getLineFragmentObjectAt(int xPos) {
        for (IZyEditableObject object : this.m_lineObjects) {
            if (xPos < object.getStart() || xPos >= object.getStart() + object.getLength()) continue;
            return object;
        }
        for (IZyEditableObject object : this.m_lineObjects) {
            if (xPos < object.getStart() || xPos - 1 >= object.getStart() + object.getLength()) continue;
            return object;
        }
        return null;
    }

    public List<IZyEditableObject> getLineFragmentObjectList() {
        return this.m_lineObjects;
    }

    public IZyEditableObject getLineObject() {
        return this.m_model;
    }

    public Object getObject(int position) {
        ObjectWrapper wrapper = this.getObjectWrapper(position);
        return wrapper == null ? null : wrapper.getObject();
    }

    public ObjectWrapper getObjectWrapper(int position) {
        for (ObjectWrapper wrapper : this.m_objects) {
            if (position < wrapper.getStart() || position >= wrapper.getStart() + wrapper.getLength()) continue;
            return wrapper;
        }
        return null;
    }

    public String getText() {
        return this.m_text;
    }

    public String getText(IZyEditableObject editabeObject) {
        Preconditions.checkNotNull(editabeObject, "Error: editabeObject argument can not be null");
        int start = editabeObject.getStart();
        int end = editabeObject.getEnd();
        if (start >= this.m_text.length()) {
            return "";
        }
        if (end >= this.m_text.length()) {
            end = this.m_text.length();
        }
        return this.m_text.substring(start, end);
    }

    public TextLayout getTextLayout() {
        if (this.isEmpty()) {
            AttributedString dummyString = new AttributedString("+");
            return new TextLayout(dummyString.getIterator(), m_fontContext);
        }
        return new TextLayout(this.m_atext.getIterator(), m_fontContext);
    }

    public boolean hasHighlighting(int level) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.m_highlighting.isEmpty()) {
            return false;
        }
        for (CHighlighting highlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (highlighting.getLevel() != level) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable(int position) {
        return this.getLineFragmentObjectAt(position) != null;
    }

    public boolean isEmpty() {
        return "".equals(this.m_text) || this.m_text == null;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.BACKGROUND, color);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setBackgroundColor(int position, int length, Color color) {
        if (!this.isEmpty()) {
            int realLength = this.calculateRealLength(position, length);
            this.validatePartialLineArguments(position, realLength);
            this.m_atext.addAttribute(TextAttribute.BACKGROUND, color, position, position + realLength);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setFont(Font font) {
        Preconditions.checkNotNull(font, "Error: Font argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.FONT, font);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
            this.updateCharBounds(font);
        }
    }

    public void setFont(int position, int length, Font font) {
        Preconditions.checkNotNull(font, "Error: Font argument can't be null");
        if (!this.isEmpty()) {
            int realLength = this.calculateRealLength(position, length);
            this.validatePartialLineArguments(position, realLength);
            Preconditions.checkNotNull(font, "Error: Font argument can't be null");
            this.m_atext.addAttribute(TextAttribute.FONT, font, position, position + realLength);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
            this.updateCharBounds(font);
        }
    }

    public synchronized boolean setHighlighting(int level, Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (this.isEmpty()) {
            return false;
        }
        for (CHighlighting highlighting : new ArrayList<CHighlighting>(this.m_highlighting)) {
            if (highlighting.getLevel() != level) continue;
            if (highlighting.getColor().equals(color)) {
                return false;
            }
            this.m_highlighting.remove(highlighting);
            break;
        }
        this.m_highlighting.add(new CHighlighting(level, 0.0, (double)this.m_text.length() * this.m_charWidth, color));
        Collections.sort(this.m_highlighting);
        return true;
    }

    public synchronized void setHighlighting(int position, int length, int level, Color color) {
        Preconditions.checkNotNull(color, "Error: color argument can not be null");
        if (!this.isEmpty()) {
            int realLength = this.calculateRealLength(position, length);
            this.validatePartialLineArguments(position, realLength);
            if (this.hasHighlighting(level)) {
                this.clearHighlighting(level);
            }
            this.m_highlighting.add(new CHighlighting(level, (double)position * this.m_charWidth, (double)realLength * this.m_charWidth, color));
            Collections.sort(this.m_highlighting);
        }
    }

    public void setObject(int start, int length, Object object) {
        Preconditions.checkNotNull(object, "Error: object argument can not be null");
        this.m_objects.add(new ObjectWrapper(start, length, object));
    }

    public void setTextColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        if (!this.isEmpty()) {
            this.m_atext.addAttribute(TextAttribute.FOREGROUND, color);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public void setTextColor(int position, int length, Color color) {
        if (!this.isEmpty()) {
            int realLength = this.calculateRealLength(position, length);
            this.validatePartialLineArguments(position, realLength);
            this.m_atext.addAttribute(TextAttribute.FOREGROUND, color, position, position + realLength);
            this.m_textLayout = new TextLayout(this.m_atext.getIterator(), m_fontContext);
        }
    }

    public String toString() {
        return this.getText();
    }

    public static class ObjectWrapper {
        private final int start;
        private final int length;
        private final Object object;

        public ObjectWrapper(int start, int length, Object object) {
            this.start = start;
            this.length = length;
            this.object = object;
        }

        public int getLength() {
            return this.length;
        }

        public Object getObject() {
            return this.object;
        }

        public int getStart() {
            return this.start;
        }
    }
}

