/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyLineEditor;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyCaret;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ZyLabelContent
implements Iterable<ZyLineContent> {
    private static final int FONTSIZE = 11;
    private static final int LINEHEIGHT = 15;
    private int m_leftPadding = 10;
    private int m_rightPadding = 10;
    private int m_topPadding = 10;
    private int m_bottomPadding = 10;
    private final IZyEditableObject m_model;
    private IZyLineEditor m_lineEditor = null;
    private final ZyCaret m_caret = new ZyCaret(this);
    private boolean m_selectable = true;
    private boolean m_editable = false;
    private boolean m_showCaret = false;
    private Color m_selectionColor = Color.WHITE;
    private final ArrayList<ZyLineContent> m_content = new ArrayList();
    private boolean m_sloppy = false;

    public ZyLabelContent(IZyEditableObject nodeModel) {
        this.m_model = nodeModel;
    }

    public ZyLabelContent(IZyEditableObject nodeModel, boolean selectable, boolean editable) {
        this.m_model = Preconditions.checkNotNull(nodeModel, "Error: Node model can't be null.");
        this.m_selectable = selectable;
        this.m_editable = editable;
    }

    private AffineTransform calcSelectionTransformationMatrix(AffineTransform currentMatrix, double xOffset, double yOffset, int linenr) {
        double scaleX = currentMatrix.getScaleX();
        double scaleY = currentMatrix.getScaleY();
        double translateX = currentMatrix.getTranslateX() + xOffset * scaleX;
        double translateY = currentMatrix.getTranslateY() + (yOffset + (double)linenr * this.getLineHeight()) * scaleY;
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, translateX, translateY);
    }

    public void addLineContent(ZyLineContent line) {
        Preconditions.checkNotNull(line, "Internal Error: Line content can't be null");
        this.m_content.add(line);
    }

    public void draw(Graphics2D gfx, double xpos, double ypos) {
        if (this.m_sloppy) {
            return;
        }
        if (!this.m_selectable || !this.m_showCaret) {
            float x2 = (float)xpos + (float)this.m_leftPadding;
            float y2 = (float)ypos + (float)this.m_topPadding + 11.0f;
            for (ZyLineContent line : this.getContent()) {
                line.draw(gfx, x2, y2);
                y2 += 15.0f;
            }
            return;
        }
        AffineTransform affineTrans = gfx.getTransform();
        Color color = gfx.getColor();
        float x3 = (float)xpos + (float)this.getPaddingLeft();
        float y3 = (float)ypos + (float)this.getPaddingTop() + (float)this.getFontSize();
        double lineheight = this.getLineHeight();
        gfx.setColor(Color.BLACK);
        for (int linenr = 0; linenr < this.getLineCount(); ++linenr) {
            TextLayout textLayout = this.getLineContent(linenr).getTextLayout();
            if (!this.getLineContent(linenr).isEmpty()) {
                textLayout.draw(gfx, x3, (float)((double)y3 + (double)linenr * lineheight));
            }
            if (linenr == this.m_caret.getYmousePressed()) {
                gfx.setTransform(this.calcSelectionTransformationMatrix(affineTrans, x3, y3, linenr));
                if (this.getLineContent(linenr).isEmpty()) {
                    this.m_caret.setCaretStartPos(0);
                } else if (this.m_caret.getCaretStartPos() >= textLayout.getCharacterCount()) {
                    this.m_caret.setCaretStartPos(textLayout.getCharacterCount());
                }
                Shape[] startCarets = textLayout.getCaretShapes(this.m_caret.getCaretStartPos());
                gfx.setColor(this.m_selectionColor.darker());
                gfx.draw(startCarets[0]);
                gfx.setTransform(affineTrans);
            }
            if (linenr != this.m_caret.getYmouseReleased()) continue;
            gfx.setTransform(this.calcSelectionTransformationMatrix(affineTrans, x3, y3, linenr));
            if (this.getLineContent(linenr).isEmpty()) {
                this.m_caret.setCaretEndPos(0);
            } else if (this.m_caret.getCaretEndPos() >= textLayout.getCharacterCount()) {
                this.m_caret.setCaretEndPos(textLayout.getCharacterCount());
            }
            Shape[] endCarets = textLayout.getCaretShapes(this.m_caret.getCaretEndPos());
            gfx.setColor(this.m_selectionColor.darker().darker());
            gfx.draw(endCarets[0]);
            gfx.setTransform(affineTrans);
        }
        if (this.m_caret.getXmousePressed() != this.m_caret.getXmouseReleased()) {
            int rp;
            int pp;
            int rl;
            int pl = this.m_caret.getYmousePressed();
            if (pl > (rl = this.m_caret.getYmouseReleased())) {
                pl = this.m_caret.getYmouseReleased();
                rl = this.m_caret.getYmousePressed();
            }
            if ((pp = this.m_caret.getXmousePressed()) > (rp = this.m_caret.getXmouseReleased())) {
                pp = this.m_caret.getXmouseReleased();
                rp = this.m_caret.getXmousePressed();
            }
            gfx.setColor(this.m_selectionColor);
            gfx.setComposite(AlphaComposite.getInstance(3, 0.5f));
            for (int linenr = pl; linenr <= rl; ++linenr) {
                gfx.setTransform(this.calcSelectionTransformationMatrix(affineTrans, x3, y3, linenr));
                TextLayout textLayout = this.getLineContent(linenr).getTextLayout();
                int rp2 = rp;
                if (pp > textLayout.getCharacterCount()) continue;
                if (this.getLineContent(linenr).isEmpty()) {
                    rp2 = pp;
                } else if (rp > textLayout.getCharacterCount()) {
                    rp2 = textLayout.getCharacterCount();
                }
                Shape selection = textLayout.getLogicalHighlightShape(pp, rp2);
                gfx.fill(selection);
            }
            gfx.setComposite(AlphaComposite.getInstance(3, 1.0f));
            gfx.setTransform(affineTrans);
        }
        gfx.setColor(color);
        gfx.setTransform(affineTrans);
    }

    public Rectangle2D getBounds() {
        double maxWidth = 0.0;
        double height = this.m_topPadding + this.m_bottomPadding;
        for (ZyLineContent content : this.getContent()) {
            if (content.getBounds().getWidth() > maxWidth) {
                maxWidth = content.getBounds().getWidth();
            }
            height += 15.0;
        }
        return new Rectangle2D.Double(0.0, 0.0, maxWidth + (double)this.m_rightPadding + (double)this.m_leftPadding, height);
    }

    public ZyCaret getCaret() {
        return this.m_caret;
    }

    public List<ZyLineContent> getContent() {
        return new ArrayList<ZyLineContent>(this.m_content);
    }

    public int getFirstLineIndexOfModelAt(int lineYPos) {
        ZyLineContent lineContent = this.getLineContent(lineYPos);
        if (lineContent != null) {
            IZyEditableObject lineModel = lineContent.getLineObject();
            int indexCopy = lineYPos;
            while (--indexCopy >= 0) {
                if (this.m_content.get(indexCopy).getLineObject() == lineModel) continue;
                return indexCopy + 1;
            }
        }
        return lineYPos;
    }

    public int getFontSize() {
        return 11;
    }

    public int getLastLineIndexOfModelAt(int lineYPos) {
        ZyLineContent lineContent = this.getLineContent(lineYPos);
        if (lineContent != null) {
            IZyEditableObject lineModel = lineContent.getLineObject();
            int indexCopy = lineYPos;
            while (++indexCopy < this.m_content.size()) {
                if (this.m_content.get(indexCopy).getLineObject() == lineModel) continue;
                return indexCopy - 1;
            }
            return this.m_content.size() - 1;
        }
        return lineYPos;
    }

    public ZyLineContent getLineContent(int line) {
        return this.m_content.get(line);
    }

    public int getLineCount() {
        return this.m_content.size();
    }

    public IZyLineEditor getLineEditor() {
        return this.m_lineEditor;
    }

    public double getLineHeight() {
        return 15.0;
    }

    public int getLineIndex(ZyLineContent line) {
        return this.m_content.indexOf(line);
    }

    public IZyEditableObject getModel() {
        return this.m_model;
    }

    public int getNonPureCommentLineIndexOfModelAt(int lineYPos) {
        ZyLineContent lineContent = this.getLineContent(lineYPos);
        if (lineContent != null) {
            int firstModelLine = this.getFirstLineIndexOfModelAt(lineYPos);
            int lastModelLine = this.getLastLineIndexOfModelAt(lineYPos);
            for (int index = firstModelLine; index <= lastModelLine; ++index) {
                ZyLineContent curLineContent = this.getLineContent(index);
                List<IZyEditableObject> lineObjects = curLineContent.getLineFragmentObjectList();
                if (curLineContent.getLineObject() != null && curLineContent.getLineObject().isPlaceholder()) continue;
                if (lineObjects.size() == 0) {
                    return index;
                }
                if (!lineObjects.get(0).isCommentDelimiter() || lineObjects.get(0).getStart() <= 0) continue;
                return index;
            }
        }
        return -1;
    }

    public int getPaddingLeft() {
        return this.m_leftPadding;
    }

    public int getPaddingTop() {
        return this.m_topPadding;
    }

    public int getRightPadding() {
        return this.m_rightPadding;
    }

    public String getSelectedText() {
        int lr;
        if (!this.m_caret.isSelection()) {
            return "";
        }
        int lp = this.m_caret.getYmousePressed();
        if (lp > (lr = this.m_caret.getYmouseReleased())) {
            lp = this.m_caret.getYmouseReleased();
            lr = this.m_caret.getYmousePressed();
        }
        int pp = this.m_caret.getXmousePressed();
        int pr = this.m_caret.getXmouseReleased();
        if (pp > this.m_caret.getXmouseReleased()) {
            pp = this.m_caret.getXmouseReleased();
            pr = this.m_caret.getXmousePressed();
        }
        StringBuilder selectedString = new StringBuilder();
        for (int y2 = lp; y2 <= lr; ++y2) {
            String line = this.getLineContent(y2).getText();
            if (line == null || line.length() < 1 || line.length() < pp) {
                selectedString.append("\n");
                continue;
            }
            if (line.length() < pr) {
                selectedString.append(line.substring(pp));
                if ("\n".equals(line) || y2 >= lr) continue;
                selectedString.append("\n");
                continue;
            }
            selectedString.append(line.substring(pp, pr));
            if ("\n".equals(line) || y2 >= lr) continue;
            selectedString.append("\n");
        }
        return selectedString.toString();
    }

    public void insertLine(ZyLineContent insertLine, int insertIndex) {
        ArrayList<ZyLineContent> newContent = new ArrayList<ZyLineContent>();
        if (insertIndex >= this.m_content.size()) {
            this.m_content.add(insertLine);
        } else {
            int index = 0;
            for (ZyLineContent line : this.getContent()) {
                if (index++ == insertIndex) {
                    newContent.add(insertLine);
                }
                newContent.add(line);
            }
            this.m_content.clear();
            this.m_content.addAll(newContent);
        }
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public boolean isSelectable() {
        return this.m_selectable;
    }

    @Override
    public Iterator<ZyLineContent> iterator() {
        return this.m_content.iterator();
    }

    public void removeLine(int removeIndex) {
        this.m_content.remove(removeIndex);
    }

    public void selectAll(IZyNodeRealizer r2) {
        this.m_caret.selectAll();
        r2.repaint();
    }

    public void setEditable(boolean editable) {
        if (this.m_model == null || this.m_lineEditor == null) {
            return;
        }
        this.m_editable = editable;
        if (this.m_editable) {
            this.m_selectable = true;
        }
    }

    public void setLineEditor(IZyLineEditor creator) {
        this.m_lineEditor = creator;
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.m_leftPadding = left;
        this.m_rightPadding = right;
        this.m_topPadding = top;
        this.m_bottomPadding = bottom;
    }

    public void setPaddingLeft(int padding) {
        this.m_leftPadding = padding;
    }

    public void setRightPadding(int right) {
        this.m_rightPadding = right;
    }

    public void setSelectable(boolean selectionMode) {
        if (this.m_model == null) {
            return;
        }
        this.m_selectable = selectionMode;
    }

    public void setSelectionColor(Color c2) {
        this.m_selectionColor = c2;
    }

    public void setSloppy(boolean isSloppy) {
        this.m_sloppy = isSloppy;
    }

    public void showCaret(boolean show) {
        this.m_showCaret = show;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ZyLineContent content : this.m_content) {
            builder.append(content.toString());
            builder.append('\n');
        }
        return builder.toString();
    }

    public void updateContentSelectionColor(Color fillColor, boolean isSelected) {
        Color nodeSelectionColor = fillColor.darker();
        if (isSelected) {
            this.setSelectionColor(nodeSelectionColor.darker());
        } else {
            this.setSelectionColor(nodeSelectionColor);
        }
    }
}

