/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class ZyCaret {
    private final ZyLabelContent m_content;
    private int m_mouse_pressed_x = 0;
    private int m_mouse_pressed_y = 0;
    private int m_mouse_released_x = 0;
    private int m_mouse_released_y = 0;
    private int m_caret_endpos_x = 0;
    private int m_caret_startpos_x = 0;

    public ZyCaret(ZyLabelContent content) {
        Preconditions.checkNotNull(content, "Error: Label content can't be null.");
        this.m_content = content;
    }

    private int calcCaretPosition(int hitLine, double x2, double y2) {
        ZyLineContent content = this.m_content.getLineContent(hitLine);
        TextLayout textlayout = this.m_content.getLineContent(hitLine).getTextLayout();
        TextHitInfo hitInfo = textlayout.hitTestChar((float)x2, (float)y2, content.getBounds());
        return hitInfo.getInsertionIndex();
    }

    private int calcHitLine(double y2) {
        int linecount = this.m_content.getLineCount();
        double lineHeight = this.m_content.getLineHeight();
        int hitline = 0;
        if (y2 < this.m_content.getLineContent(0).getBounds().getMinY()) {
            hitline = 0;
        } else if (y2 > this.m_content.getLineContent(linecount - 1).getBounds().getMinY() + (double)linecount * lineHeight) {
            hitline = linecount - 1;
        } else {
            for (int line = 0; line < linecount; ++line) {
                Rectangle2D bounds = this.m_content.getLineContent(line).getBounds();
                double boundY = bounds.getY() + (double)line * lineHeight + (double)this.m_content.getPaddingTop();
                if (!((bounds = new Rectangle2D.Double(bounds.getX(), boundY, bounds.getWidth(), bounds.getHeight())).getY() < y2) || !(bounds.getY() + lineHeight > y2)) continue;
                hitline = line;
                break;
            }
        }
        return hitline;
    }

    private int calcHitPosition(int caretPosition, double x2, double y2, double zoomFactor) {
        boolean switched = false;
        int lp = this.m_mouse_pressed_y;
        int lr = this.m_mouse_released_y;
        if (lp > lr) {
            lp = this.m_mouse_released_y;
            lr = this.m_mouse_pressed_y;
            switched = true;
        }
        int linecount = this.m_content.getLineCount();
        double height = (float)this.m_content.getLineHeight();
        int maxIndex = caretPosition;
        for (int line = lp; line <= lr; ++line) {
            double deltaY = 0.0;
            deltaY = switched ? height * zoomFactor * (double)line : -(height * zoomFactor * (double)(linecount - line));
            TextLayout textLayout = this.m_content.getLineContent(line).getTextLayout();
            TextHitInfo hitInfo = textLayout.hitTestChar((float)x2, (float)(y2 + deltaY), textLayout.getBounds());
            int insertionIndex = hitInfo.getInsertionIndex();
            if (caretPosition >= insertionIndex || insertionIndex <= maxIndex) continue;
            maxIndex = insertionIndex;
        }
        return maxIndex;
    }

    private int calcSelectedLinesMaxLength() {
        int lp = this.m_mouse_pressed_y;
        int lr = this.m_mouse_released_y;
        if (lp > lr) {
            lp = this.m_mouse_released_y;
            lr = this.m_mouse_pressed_y;
        }
        int length = 0;
        for (int y2 = lp; y2 <= lr; ++y2) {
            length = Math.max(length, this.m_content.getLineContent(y2).getText().length());
        }
        return length;
    }

    private int getLastLineXPos(int lineYPos) {
        ZyLineContent lineContent = this.m_content.getLineContent(lineYPos);
        String text2 = lineContent.getText();
        if (text2.endsWith("\n") || text2.endsWith("\r")) {
            return text2.length() - 1;
        }
        return text2.length();
    }

    public int getCaretEndPos() {
        return this.m_caret_endpos_x;
    }

    public int getCaretStartPos() {
        return this.m_caret_startpos_x;
    }

    public int getMaxLineLength(int startY, int endY) {
        int max = 0;
        if (startY > endY) {
            int temp = startY;
            startY = endY;
            endY = temp;
        }
        for (int lineIndex = startY; lineIndex <= endY; ++lineIndex) {
            ZyLineContent lineContent = this.m_content.getLineContent(lineIndex);
            int length = lineContent.getText().length();
            if (max >= length) continue;
            max = length;
        }
        return max;
    }

    public int getXmousePressed() {
        return this.m_mouse_pressed_x;
    }

    public int getXmouseReleased() {
        return this.m_mouse_released_x;
    }

    public int getYmousePressed() {
        return this.m_mouse_pressed_y;
    }

    public int getYmouseReleased() {
        return this.m_mouse_released_y;
    }

    public boolean isSelection() {
        boolean isSingleLineSelection;
        boolean bl2 = isSingleLineSelection = this.getXmousePressed() != this.getXmouseReleased() && this.getYmousePressed() == this.getYmouseReleased();
        if (isSingleLineSelection) {
            int maxIndex = this.m_content.getLastLineIndexOfModelAt(this.m_mouse_pressed_y);
            return maxIndex >= this.m_mouse_pressed_y;
        }
        return this.getXmousePressed() != this.getXmouseReleased() || this.getYmousePressed() != this.getYmouseReleased();
    }

    public void selectAll() {
        this.m_mouse_pressed_x = 0;
        this.m_mouse_pressed_y = 0;
        this.m_mouse_released_y = this.m_content.getLineCount() - 1;
        this.m_mouse_released_x = this.calcSelectedLinesMaxLength();
        this.m_caret_startpos_x = this.m_mouse_pressed_x;
        this.m_caret_endpos_x = this.m_mouse_released_x;
    }

    public void selectLine(double labelParentY, double mouseY) {
        double y2 = mouseY - labelParentY - (double)this.m_content.getPaddingTop();
        this.m_mouse_pressed_y = this.m_mouse_released_y = this.calcHitLine(y2);
        this.m_mouse_released_x = this.m_content.getLineContent(this.m_mouse_pressed_y).getTextLayout().getCharacterCount();
        this.m_mouse_pressed_x = 0;
        this.m_caret_endpos_x = this.m_mouse_released_x;
        this.m_caret_startpos_x = this.m_mouse_pressed_x;
    }

    public void selectWord(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor) {
        int charX;
        double x2 = mouseX - labelParentX - (double)this.m_content.getPaddingLeft();
        double y2 = mouseY - labelParentY - (double)this.m_content.getPaddingTop();
        this.m_mouse_pressed_y = this.m_mouse_released_y = this.calcHitLine(y2);
        this.m_mouse_released_x = this.calcHitPosition(this.m_caret_endpos_x, (float)x2, (float)y2, zoomFactor);
        String s2 = this.m_content.getLineContent(this.m_mouse_released_y).getText();
        if (this.m_mouse_released_x > s2.length() - 1) {
            return;
        }
        if (s2.charAt(this.m_mouse_released_x) == ' ') {
            return;
        }
        this.m_caret_endpos_x = s2.length();
        for (charX = this.m_mouse_released_x; charX < this.m_caret_endpos_x; ++charX) {
            if (s2.charAt(charX) != ' ') continue;
            this.m_caret_endpos_x = charX;
            break;
        }
        this.m_caret_startpos_x = 0;
        for (charX = this.m_mouse_released_x; charX >= 0; --charX) {
            if (s2.charAt(charX) != ' ') continue;
            this.m_caret_startpos_x = charX + 1;
            break;
        }
        this.m_mouse_pressed_x = this.m_caret_startpos_x;
        this.m_mouse_released_x = this.m_caret_endpos_x;
    }

    public void setCaret(int caretStartPos_X, int mousePressed_X, int mousePressed_Y, int caretEndPos_X, int mouseReleased_X, int mouseReleased_Y) {
        int lastReleasedXPos;
        int lastPressedXPos = this.getLastLineXPos(mousePressed_Y);
        if (caretStartPos_X > lastPressedXPos) {
            caretStartPos_X = lastPressedXPos;
        }
        if (mousePressed_X > lastPressedXPos) {
            mousePressed_X = lastPressedXPos;
        }
        if (caretEndPos_X > (lastReleasedXPos = this.getLastLineXPos(mouseReleased_Y))) {
            caretEndPos_X = lastReleasedXPos;
        }
        this.m_caret_startpos_x = caretStartPos_X;
        this.m_mouse_pressed_x = mousePressed_X;
        this.m_mouse_pressed_y = mousePressed_Y;
        this.m_caret_endpos_x = caretEndPos_X;
        this.m_mouse_released_x = mouseReleased_X;
        this.m_mouse_released_y = mouseReleased_Y;
    }

    public void setCaretEnd(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor) {
        double x2 = mouseX - labelParentX - (double)this.m_content.getPaddingLeft();
        double y2 = mouseY - labelParentY;
        this.m_mouse_released_y = this.calcHitLine(y2);
        this.m_caret_endpos_x = this.calcCaretPosition(this.m_mouse_released_y, x2, y2);
        this.m_mouse_released_x = this.calcHitPosition(this.m_caret_endpos_x, x2, y2, zoomFactor);
    }

    public void setCaretEndPos(int endPos) {
        int lastReleasedXPos = this.getLastLineXPos(this.m_mouse_released_y);
        if (endPos > lastReleasedXPos) {
            endPos = lastReleasedXPos;
        }
        this.m_caret_endpos_x = endPos;
    }

    public void setCaretStart(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor) {
        double x2 = mouseX - labelParentX - (double)this.m_content.getPaddingLeft();
        double y2 = mouseY - labelParentY;
        this.m_mouse_pressed_y = this.calcHitLine(y2);
        this.m_caret_startpos_x = this.calcCaretPosition(this.m_mouse_pressed_y, x2, y2);
        this.m_mouse_pressed_x = this.calcHitPosition(this.m_caret_startpos_x, x2, y2, zoomFactor);
    }

    public void setCaretStartPos(int startPos) {
        int lastPressedXPos = this.getLastLineXPos(this.m_mouse_pressed_y);
        if (startPos > lastPressedXPos) {
            startPos = lastPressedXPos;
        }
        this.m_caret_startpos_x = startPos;
    }

    public void setXmousePressed(int mouseXPos) {
        int lastPressedXPos = this.getLastLineXPos(this.m_mouse_pressed_y);
        if (mouseXPos > lastPressedXPos) {
            mouseXPos = lastPressedXPos;
        }
        this.m_mouse_pressed_x = mouseXPos;
    }

    public void setXmouseReleased(int mouseXPos) {
        int lastReleasedXPos = this.getLastLineXPos(this.m_mouse_released_y);
        if (mouseXPos > lastReleasedXPos) {
            mouseXPos = lastReleasedXPos;
        }
        this.m_mouse_released_x = mouseXPos;
    }

    public void setYmousePressed(int mouseYPos) {
        this.m_mouse_pressed_y = mouseYPos;
    }

    public void setYmouseReleased(int mouseYPos) {
        this.m_mouse_released_y = mouseYPos;
    }
}

