/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;

public class CUndoStateData {
    private final ZyLabelContent m_labelContent;
    private final Object m_persistentModel;
    private final IZyEditableObject m_editableObject;
    private final String m_text;
    private final boolean m_isAboveLineComment;
    private final boolean m_isBehindLineComment;
    private final boolean m_isLabelComment;
    private final int m_caretStartX;
    private final int m_caretMousePressedX;
    private final int m_caretMousePressedY;
    private final int m_caretEndX;
    private final int m_caretMouseReleasedX;
    private final int m_caretMouseReleasedY;

    public CUndoStateData(ZyLabelContent labelContent, Object persistentModel, IZyEditableObject editableObject, String text2, boolean isAboveLineComment, boolean isBehindLineComment, boolean isLabelComment, int caretStartX, int caretMousePressedX, int caretMousePressedY, int caretEndX, int caretMouseReleasedX, int caretMouseReleasedY) {
        Preconditions.checkNotNull(labelContent, "Error: Label content can't be null.");
        Preconditions.checkNotNull(persistentModel, "Error: Persistent model can't be null.");
        Preconditions.checkNotNull(editableObject, "Error: Editable object cant be null.");
        Preconditions.checkNotNull(text2, "Error: Text can't be null.");
        this.m_labelContent = labelContent;
        this.m_persistentModel = persistentModel;
        this.m_editableObject = editableObject;
        this.m_text = text2;
        this.m_isAboveLineComment = isAboveLineComment;
        this.m_isBehindLineComment = isBehindLineComment;
        this.m_isLabelComment = isLabelComment;
        this.m_caretStartX = caretStartX;
        this.m_caretMousePressedX = caretMousePressedX;
        this.m_caretMousePressedY = caretMousePressedY;
        this.m_caretEndX = caretEndX;
        this.m_caretMouseReleasedX = caretMouseReleasedX;
        this.m_caretMouseReleasedY = caretMouseReleasedY;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUndoStateData) {
            CUndoStateData undoData = (CUndoStateData)obj;
            return this.m_isAboveLineComment == undoData.m_isAboveLineComment && this.m_isBehindLineComment == undoData.m_isBehindLineComment && this.m_isLabelComment == undoData.m_isLabelComment && this.m_persistentModel == undoData.m_persistentModel && this.m_text.equals(undoData.m_text);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        int tempHash = 64 + this.m_text.hashCode();
        hash += this.m_isAboveLineComment ? 1 : 2;
        hash += this.m_isBehindLineComment ? 4 : 8;
        hash += this.m_isBehindLineComment ? 16 : 32;
        return hash += (tempHash *= this.m_persistentModel.hashCode());
    }

    public void restore() {
        if (this.m_isAboveLineComment) {
            this.m_editableObject.updateComment(this.m_text, ECommentPlacement.ABOVE_LINE);
        } else if (this.m_isBehindLineComment) {
            this.m_editableObject.updateComment(this.m_text, ECommentPlacement.BEHIND_LINE);
        } else if (this.m_isLabelComment) {
            this.m_editableObject.update(this.m_text);
        } else {
            throw new RuntimeException("Not implemented yet.");
        }
        this.m_labelContent.getLineEditor().recreateLabelLines(this.m_labelContent, this.m_persistentModel);
        this.m_labelContent.getCaret().setCaret(this.m_caretStartX, this.m_caretMousePressedX, this.m_caretMousePressedY, this.m_caretEndX, this.m_caretMouseReleasedX, this.m_caretMouseReleasedY);
    }
}

