/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Point;

public class CDelKeyBehavior
extends CAbstractKeyBehavior {
    private boolean m_wasSelection = false;
    private IZyEditableObject m_editableObject;
    private boolean m_isAboveComment;
    private boolean m_isBehindComment;
    private boolean m_isLabelComment;

    public CDelKeyBehavior(CUndoManager undoManager) {
        super(undoManager);
    }

    private Point getMultiCommentEndPoint(int lineXPos, int lineYPos) {
        if (this.isComment(lineXPos, lineYPos)) {
            ZyLineContent lineContent = this.getLineContent(lineYPos);
            int x2 = lineContent.getLineFragmentObjectList().get(lineContent.getLineFragmentObjectList().size() - 1).getEnd();
            int y2 = lineYPos;
            for (int index = lineYPos + 1; index <= this.getLabelContent().getLastLineIndexOfModelAt(lineYPos); ++index) {
                ZyLineContent nextLineContent = this.getLineContent(index);
                int editableObjectSize = nextLineContent.getLineFragmentObjectList().size();
                IZyEditableObject firstEditableObject = nextLineContent.getLineFragmentObjectAt(0);
                if (firstEditableObject == null) break;
                if (!firstEditableObject.isCommentDelimiter()) continue;
                x2 = nextLineContent.getLineFragmentObjectAt(editableObjectSize - 1).getEnd();
                y2 = index;
            }
            return new Point(x2, y2);
        }
        return null;
    }

    @Override
    protected void initUndoHistory() {
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        IZyEditableObject lineFragmentObject = lineContent.getLineFragmentObjectAt(x2);
        this.m_editableObject = lineContent.getLineObject();
        if (lineFragmentObject != null) {
            String text2 = lineContent.getText().substring(lineFragmentObject.getStart(), lineFragmentObject.getEnd());
            this.m_isAboveComment = this.isAboveLineComment(y2);
            this.m_isBehindComment = this.isBehindLineComment(x2, y2);
            this.m_isLabelComment = this.isLabelComment(y2);
            if (this.isComment(x2, y2)) {
                text2 = this.getMultiLineComment(y2);
            }
            this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), this.m_editableObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }

    @Override
    protected void updateCaret() {
        this.m_wasSelection = false;
    }

    @Override
    protected void updateClipboard() {
        if (this.isShiftPressed() && !this.isCtrlPressed() && !this.isAltPressed()) {
            String clipboardText = this.getSelectedText();
            ClipboardHelpers.copyToClipboard(clipboardText);
        }
    }

    @Override
    protected void updateLabelContent() {
        if (this.m_wasSelection) {
            return;
        }
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        IZyEditableObject editableObject = lineContent.getLineFragmentObjectAt(x2);
        if (editableObject == null) {
            return;
        }
        if (this.isComment(x2, y2)) {
            IZyEditableObject object;
            ZyLineContent nextLineContent;
            String text2;
            if (editableObject.isCommentDelimiter()) {
                return;
            }
            Point commentEndPoint = this.getMultiCommentEndPoint(x2, y2);
            if (y2 == commentEndPoint.y && (x2 == commentEndPoint.x || x2 == commentEndPoint.x - 1 && lineContent.getText().endsWith("\n"))) {
                return;
            }
            int textCursor = x2 - editableObject.getStart();
            String changedText = text2 = lineContent.getText().substring(editableObject.getStart(), editableObject.getEnd());
            if (textCursor < text2.length()) {
                changedText = String.format("%s%s", text2.substring(0, textCursor), text2.substring(textCursor + 1));
            } else if (this.isComment(x2, y2) && y2 < this.getLabelContent().getLineCount() - 1 && (nextLineContent = this.getLineContent(y2 + 1)).getLineObject() == lineContent.getLineObject() && (object = nextLineContent.getLineFragmentObjectAt(0)) != null && object.isCommentDelimiter()) {
                changedText = text2.substring(0, textCursor - 1);
            }
            if (this.isComment(x2, y2) && !(changedText = this.getMultilineComment(y2, changedText)).endsWith("\r")) {
                changedText = String.valueOf(changedText).concat("\r");
            }
            editableObject.update(changedText);
            if (this.isLabelComment(y2)) {
                lineContent.getLineObject().update(changedText);
            } else if (this.isAboveLineComment(y2)) {
                lineContent.getLineObject().updateComment(changedText, ECommentPlacement.ABOVE_LINE);
            } else if (this.isBehindLineComment(x2, y2)) {
                lineContent.getLineObject().updateComment(changedText, ECommentPlacement.BEHIND_LINE);
            }
        } else {
            throw new RuntimeException("Not implemented yet.");
        }
        this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), lineContent.getLineObject().getPersistentModel());
    }

    @Override
    protected void updateSelection() {
        this.m_wasSelection = this.isSelection();
        this.deleteSelection();
    }

    @Override
    protected void updateUndoHistory() {
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        IZyEditableObject lineFragmentObject = lineContent.getLineFragmentObjectAt(x2);
        String text2 = "";
        if (lineFragmentObject != null) {
            text2 = lineContent.getText().substring(lineFragmentObject.getStart(), lineFragmentObject.getEnd());
            if (this.isComment(x2, y2)) {
                text2 = this.getMultiLineComment(y2);
            }
            this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), this.m_editableObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }
}

